/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.PrologStream;
import gnu.prolog.vm.TermConstants;

public class Predicate_peek_char
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        PrologStream stream = interpreter.getEnvironment().resolveStream(args[0]);
        Term inchar = args[1];
        if (inchar instanceof AtomTerm) {
            AtomTerm ch = (AtomTerm)inchar;
            if (ch != PrologStream.endOfFileAtom & ch.value.length() != 1) {
                PrologException.typeError(TermConstants.inCharacterAtom, inchar);
            }
        } else if (!(inchar instanceof VariableTerm)) {
            PrologException.typeError(TermConstants.inCharacterAtom, inchar);
        }
        int inch = stream.peekCode(args[0], interpreter);
        AtomTerm rc = inch == -1 ? PrologStream.endOfFileAtom : AtomTerm.get((char)inch);
        return interpreter.unify(inchar, rc);
    }
}

