/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class OtherDriverUIContributor
implements IDriverUIContributor,
Listener {
    private ScrolledComposite scrolledComposite = null;
    protected Text databaseNameText;
    protected Text urlText;
    protected Text usernameText;
    protected Text passwordText;
    protected Button savePasswordButton;
    protected OptionalPropertiesPane optionalPropsComposite;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    protected DialogPage parentPage;
    protected boolean isReadOnly = false;

    @Override
    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.scrolledComposite == null || this.scrolledComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.scrolledComposite = new ScrolledComposite(parent, 768);
            this.scrolledComposite.setExpandHorizontal(true);
            this.scrolledComposite.setExpandVertical(true);
            this.scrolledComposite.setLayout((Layout)new GridLayout());
            TabFolder parentComposite = new TabFolder((Composite)this.scrolledComposite, 128);
            TabItem generalTab = new TabItem(parentComposite, 0);
            generalTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.generaltab"));
            TabItem optionalTab = new TabItem(parentComposite, 0);
            optionalTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionaltab"));
            this.optionalPropsComposite = new OptionalPropertiesPane((Composite)parentComposite, 0, isReadOnly);
            optionalTab.setControl((Control)this.optionalPropsComposite);
            Composite generalComposite = new Composite((Composite)parentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            generalComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)generalComposite);
            Label databaseNameLabel = new Label(generalComposite, 0);
            databaseNameLabel.setLayoutData((Object)new GridData());
            databaseNameLabel.setText(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.databaseName.label"));
            this.databaseNameText = new Text(generalComposite, 0x800 | additionalStyles);
            this.databaseNameText.setLayoutData((Object)new GridData(768));
            Label urlLabel = new Label(generalComposite, 0);
            urlLabel.setLayoutData((Object)new GridData());
            urlLabel.setText(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.url.label"));
            this.urlText = new Text(generalComposite, 0x800 | additionalStyles);
            this.urlText.setLayoutData((Object)new GridData(768));
            Label usernameLabel = new Label(generalComposite, 0);
            usernameLabel.setLayoutData((Object)new GridData());
            usernameLabel.setText(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.userName.label"));
            this.usernameText = new Text(generalComposite, 0x800 | additionalStyles);
            this.usernameText.setLayoutData((Object)new GridData(768));
            Label passwordLabel = new Label(generalComposite, 0);
            passwordLabel.setLayoutData((Object)new GridData());
            passwordLabel.setText(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.password.label"));
            this.passwordText = new Text(generalComposite, 0x400800 | additionalStyles);
            this.passwordText.setLayoutData((Object)new GridData(768));
            this.savePasswordButton = new Button(generalComposite, 32);
            this.savePasswordButton.setText(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.savePassword.label"));
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.scrolledComposite.setContent((Control)parentComposite);
            this.scrolledComposite.setMinSize(parentComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.scrolledComposite;
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseNameText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    private void removeListeners() {
        this.databaseNameText.removeListener(24, (Listener)this);
        this.urlText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
    }

    private void addListeners() {
        this.databaseNameText.addListener(24, (Listener)this);
        this.urlText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
    }

    private void initialize() {
        this.addListeners();
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            }
        } else {
            this.setConnectionInformation();
        }
    }

    @Override
    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseNameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.errormessage.requiresdatabase"));
            isComplete = false;
        } else if (this.urlText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.errormessage.requiresurl"));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.errormessage.requiresusername"));
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    @Override
    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    @Override
    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
    }

    @Override
    public void loadProperties() {
        String savePassword;
        String password;
        String username;
        String url;
        this.removeListeners();
        String databaseName = this.properties.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        if (databaseName != null) {
            this.databaseNameText.setText(databaseName);
        }
        if ((url = this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL")) != null) {
            this.urlText.setText(url);
        }
        if ((username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username")) != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        this.optionalPropsComposite.loadProperties();
        this.addListeners();
        this.setConnectionInformation();
    }

    @Override
    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.summaryData.database"), this.databaseNameText.getText().trim()});
        summaryData.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.summaryData.username"), this.usernameText.getText().trim()});
        summaryData.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.summaryData.url"), this.urlText.getText().trim()});
        summaryData.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.summaryData.savePassword"), this.savePasswordButton.getSelection() ? ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.summaryData.true") : ConnectivityUIPlugin.getDefault().getResourceString("OtherDriverUIContributor.summaryData.false")});
        return summaryData;
    }
}

