/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparableSequence<T extends Comparable<? super T>>
implements Comparable<ComparableSequence<? extends T>> {
    private final LinkedList<T> _contents = new LinkedList();

    public ComparableSequence() {
    }

    public ComparableSequence(List<? extends T> element_p) {
        this();
        this._contents.addAll(element_p);
    }

    public ComparableSequence(T[] elements_p) {
        this(Arrays.asList(elements_p));
    }

    public void append(T element_p) {
        this._contents.addLast(element_p);
    }

    @Override
    public int compareTo(ComparableSequence<? extends T> path_p) {
        Iterator<T> it1 = this.getContents().iterator();
        Iterator<T> it2 = path_p.getContents().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            int result = ((Comparable)it1.next()).compareTo(it2.next());
            if (result == 0) continue;
            return result;
        }
        return this.size() - path_p.size();
    }

    public boolean equals(Object obj_p) {
        return obj_p instanceof ComparableSequence && ((ComparableSequence)obj_p).getContents().equals(this.getContents());
    }

    public List<T> getContents() {
        return Collections.unmodifiableList(this._contents);
    }

    protected char getSeparator() {
        return '.';
    }

    public int hashCode() {
        return this.getContents().hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void prepend(T element_p) {
        this._contents.addFirst(element_p);
    }

    public int size() {
        return this.getContents().size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        char SEPARATOR = this.getSeparator();
        boolean first = true;
        for (Comparable fragment : this._contents) {
            if (first) {
                first = false;
            } else {
                builder.append(SEPARATOR);
            }
            builder.append(fragment);
        }
        return builder.toString();
    }
}

