/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.common.comparable;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.diffmerge.structures.Structures;
import org.eclipse.emf.diffmerge.structures.common.comparable.IComparableStructure;

public class ComparableHashMap<K extends Comparable<?>, V extends Comparable<?>>
extends BasicEMap<K, V>
implements IComparableStructure<IComparableStructure.IComparableMapEntry<K, V>> {
    private static final long serialVersionUID = 1L;
    private final boolean _useEqualsForKeys;
    private final boolean _useEqualsForValues;

    public ComparableHashMap() {
        this(true, true);
    }

    public ComparableHashMap(boolean useEqualsForKeys_p, boolean useEqualsForValues_p) {
        this._useEqualsForKeys = useEqualsForKeys_p;
        this._useEqualsForValues = useEqualsForValues_p;
    }

    public ComparableHashMap(int initialCapacity_p, boolean useEqualsForKeys_p, boolean useEqualsForValues_p) {
        super(initialCapacity_p);
        this._useEqualsForKeys = useEqualsForKeys_p;
        this._useEqualsForValues = useEqualsForValues_p;
    }

    public ComparableHashMap(Map<? extends K, ? extends V> map_p, boolean useEqualsForKeys_p, boolean useEqualsForValues_p) {
        super(map_p);
        this._useEqualsForKeys = useEqualsForKeys_p;
        this._useEqualsForValues = useEqualsForValues_p;
    }

    @Override
    public int compareTo(IComparableStructure<?> o_p) {
        return STRUCTURE_COMPARATOR.compare(this, o_p);
    }

    @Override
    public Iterator<IComparableStructure.IComparableMapEntry<K, V>> getCompareIterator() {
        Object[] contents = this.toArray();
        Arrays.sort(contents);
        return Arrays.asList(contents).iterator();
    }

    protected BasicEMap.Entry<K, V> newEntry(int hash, K key, V value) {
        this.validateKey(key);
        this.validateValue(value);
        return new ComparableEntryImpl(this, hash, key, value);
    }

    protected BasicEList<BasicEMap.Entry<K, V>> newList() {
        return new BasicEList<BasicEMap.Entry<K, V>>(){
            private static final long serialVersionUID = 1L;

            public Object[] newData(int listCapacity) {
                return new ComparableEntryImpl[listCapacity];
            }
        };
    }

    public String toString() {
        return Structures.toIterableString(this);
    }

    protected boolean useEqualsForKey() {
        return this._useEqualsForKeys;
    }

    protected boolean useEqualsForValue() {
        return this._useEqualsForValues;
    }

    protected static class ComparableEntryImpl
    extends BasicEMap.EntryImpl
    implements IComparableStructure.IComparableMapEntry<K, V> {
        final /* synthetic */ ComparableHashMap this$0;

        public ComparableEntryImpl(int hash_p, K key_p, V value_p) {
            this.this$0 = var1_1;
            super((BasicEMap)var1_1, hash_p, key_p, value_p);
        }

        @Override
        public int compareTo(IComparableStructure<?> o_p) {
            return STRUCTURE_COMPARATOR.compare(this, o_p);
        }

        @Override
        public Iterator<Comparable<?>> getCompareIterator() {
            return Arrays.asList((Comparable)this.getKey(), (Comparable)this.getValue()).iterator();
        }

        public String toString() {
            return Structures.toMapEntryString(this);
        }
    }
}

