/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.impl;

import java.util.Collection;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingCause;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IRule;
import org.eclipse.emf.diffmerge.bridge.util.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingCause<S, T>
implements IMappingCause<S, T> {
    private final IQueryExecution _queryExecution;
    private final S _source;
    private final IRule<? super S, ?, T> _rule;

    public MappingCause(IQueryExecution queryExecution_p, S source_p, IRule<? super S, ?, T> rule_p) {
        this._queryExecution = queryExecution_p;
        this._source = source_p;
        this._rule = rule_p;
    }

    public boolean equals(Object other_p) {
        boolean result = false;
        if (other_p instanceof MappingCause) {
            MappingCause peer = (MappingCause)other_p;
            IQueryExecution qex = this.getQueryExecution();
            result = (qex == null || qex.equals(peer.getQueryExecution())) && this.getSource().equals(peer.getSource()) && this.getRule().equals(peer.getRule());
        }
        return result;
    }

    @Override
    public IQueryExecution getQueryExecution() {
        return this._queryExecution;
    }

    @Override
    public IRule<? super S, ?, T> getRule() {
        return this._rule;
    }

    @Override
    public S getSource() {
        return this._source;
    }

    public Collection<?> getSourceElements() {
        Collection result = CollectionsUtil.flatten(this._source);
        return result;
    }

    public Object getSymbol(ISymbolFunction function_p) {
        Object ruleIdentification;
        String result = null;
        Object sourceIdentification = function_p.getSymbol(this._source);
        if (sourceIdentification != null && (ruleIdentification = function_p.getSymbol(this._rule)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Source[");
            builder.append(sourceIdentification);
            builder.append("]_Rule[");
            builder.append(ruleIdentification);
            builder.append(']');
            result = builder.toString();
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        IQueryExecution qex = this.getQueryExecution();
        int result = 1;
        result = 31 * result + (qex == null ? 0 : qex.hashCode());
        result = 31 * result + this.getSource().hashCode();
        result = 31 * result + this.getRule().hashCode();
        return result;
    }
}

