/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.common;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.emf.diffmerge.structures.IEqualityBasedStructure;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;

public class FLinkedList<E>
extends LinkedList<E>
implements IEqualityBasedStructure {
    private static final long serialVersionUID = 1L;
    private IEqualityTester _equalityTester;

    public FLinkedList() {
        this((IEqualityTester)null);
    }

    public FLinkedList(IEqualityTester tester_p) {
        this.setEqualityTester(tester_p);
    }

    public FLinkedList(Collection<? extends E> collection_p, IEqualityTester tester_p) {
        super(collection_p);
        this.setEqualityTester(tester_p);
    }

    @Override
    public IEqualityTester getEqualityTester() {
        return this._equalityTester;
    }

    @Override
    public int indexOf(Object object_p) {
        ListIterator it = this.listIterator();
        int i = 0;
        while (it.hasNext()) {
            if (this.getEqualityTester().areEqual(object_p, it.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object_p) {
        int i = this.size();
        ListIterator it = this.listIterator(i);
        while (it.hasPrevious()) {
            --i;
            if (!this.getEqualityTester().areEqual(object_p, it.previous())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(Object object_p) {
        boolean result;
        int i = this.indexOf(object_p);
        boolean bl = result = i >= 0;
        if (result) {
            this.remove(i);
        }
        return result;
    }

    private void setEqualityTester(IEqualityTester tester_p) {
        this._equalityTester = tester_p != null ? tester_p : DEFAULT_TESTER;
    }
}

