/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.specifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicElementLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractMultiRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IMultiRoleBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.AdditionKind;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePatternApplicationSpecification
extends AbstractMultiRoleSelection
implements IMultiRoleBasedSpecification {
    private BasicPatternApplication _application = null;
    private final List<EObject> _modelElements = new FOrderedSet();
    private boolean _unfoldWhenDone;
    private boolean _displayWhenDone;
    private boolean _reuseLayout;
    private boolean _reuseStyle;
    private int _numberOfApplications;
    private int _multiplicity;
    private String _namingRule;

    public TemplatePatternApplicationSpecification(List<? extends Object> initialSelection_p) {
        for (Object object : initialSelection_p) {
            if (!(object instanceof EObject)) continue;
            this._modelElements.add((EObject)object);
        }
        this._unfoldWhenDone = true;
        this._reuseLayout = true;
        this._reuseStyle = true;
        this._displayWhenDone = true;
        this._numberOfApplications = 1;
        this._multiplicity = 1;
        this._namingRule = NamingUtil.getNeutralRenamingRule();
    }

    private void applyDefaultAssociation(BasicPatternApplication application_p, Collection<? extends EObject> elements_p) {
        Iterator<? extends EObject> it = elements_p.iterator();
        while (!application_p.isComplete() && it.hasNext()) {
            EObject current = it.next();
            this.applyDefaultAssociation(application_p, current);
        }
    }

    private void applyDefaultAssociation(BasicPatternApplication application_p, EObject element_p) {
        ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(element_p);
        for (TemplatePatternRole role : this.getPattern().getRoles()) {
            EReference containment;
            List<EReference> containments;
            EClass type;
            if (application_p.isCompleteOn((IPatternRole)role) || !role.acceptsAddition() || (type = ModelsUtil.getCommonType((Collection)role.getTemplateElements())) == null || (containments = ruleProvider.getReferencesForAddition(element_p, type, true, true)) == null || containments.size() != 1 || !ruleProvider.supportsAdditionOf(element_p, containment = containments.get(0), (Collection<? extends EObject>)role.getTemplateElements(), true)) continue;
            BasicReferenceLocation location = new BasicReferenceLocation(element_p, containment);
            application_p.setLocation((IPatternRole)role, (ILocation)location);
        }
    }

    public List<TemplatePatternRole> getAdditionRolesOf(EObject modelElement_p) {
        List result = this.getApplication() != null ? this.getApplication().getAdditionRolesOf(modelElement_p) : Collections.emptyList();
        return result;
    }

    @Override
    public Collection<EObject> getAllElements() {
        return ModelsUtil.getAllContents(this.getSelectedElements(), (boolean)true, null);
    }

    public Collection<IReferenceLocation> getApplicableAdditionLocations(TemplatePatternRole role_p, EObject element_p) {
        ArrayList<BasicReferenceLocation> result = new ArrayList<BasicReferenceLocation>();
        if (role_p != null && role_p.acceptsAddition()) {
            if (role_p.getAdditionKind() == AdditionKind.PREFERRED_CONTAINMENT) {
                EReference preferred = role_p.getPreferredContainment();
                if (element_p.eClass().getEAllContainments().contains((Object)preferred)) {
                    BasicReferenceLocation location = new BasicReferenceLocation(element_p, preferred);
                    result.add(location);
                }
            } else {
                EClass requirement = ModelsUtil.getCommonType((Collection)role_p.getTemplateElements());
                ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(element_p);
                List<EReference> references = ruleProvider.getReferencesForAddition(element_p, requirement, true, true);
                if (references != null) {
                    for (EReference reference : references) {
                        BasicReferenceLocation location = new BasicReferenceLocation(element_p, reference);
                        result.add(location);
                    }
                }
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public IElementLocation getApplicableMergeLocation(TemplatePatternRole role_p, EObject element_p) {
        BasicElementLocation location;
        BasicElementLocation result = null;
        if (role_p != null && role_p.acceptsMerge() && role_p.checkApplicability((ILocation)(location = new BasicElementLocation(element_p)), (IPatternApplication)this.getApplication()).isOk()) {
            result = location;
        }
        return result;
    }

    public BasicPatternApplication getApplication() {
        return this._application;
    }

    public int getMultiplicity() {
        return this._multiplicity;
    }

    public int getNumberOfApplications() {
        return this._numberOfApplications;
    }

    public String getNamingRule() {
        return this._namingRule;
    }

    public List<TemplatePatternRole> getRolesOf(EObject modelElement_p) {
        List result = this.getApplication() != null ? this.getApplication().getRolesOf(modelElement_p) : Collections.emptyList();
        return result;
    }

    public Object getScopeElement() {
        return this.getSelectedElements().isEmpty() ? this.getApplication().getScopeElement() : this.getSelectedElements().get(0);
    }

    public List<EObject> getSelectedElements() {
        return this._modelElements;
    }

    @Override
    public boolean isAcceptable(TemplatePattern pattern_p) {
        return true;
    }

    public boolean isAssigned(TemplatePatternRole role_p) {
        ILocation location;
        boolean result = false;
        if (this.getApplication() != null && (location = this.getApplication().getLocation((IPatternRole)role_p)) != null) {
            result = !location.getAtomicContents().isEmpty();
        }
        return result;
    }

    public boolean isComplete() {
        return this._application != null && this.isMergeComplete((IPatternApplication)this._application);
    }

    private boolean isMergeComplete(IPatternApplication application_p) {
        for (TemplatePatternRole role : this.getPattern().getRoles()) {
            if (role.acceptsAddition() || application_p.isCompleteOn((IPatternRole)role)) continue;
            return false;
        }
        return true;
    }

    public boolean mayReuseLayoutAndStyle() {
        return this.getPattern() != null && !this.getPattern().getLayoutData().isEmpty();
    }

    public boolean mustDisplayWhenDone() {
        return this._displayWhenDone;
    }

    public boolean mustReuseLayout() {
        return this._reuseLayout;
    }

    public boolean mustReuseStyle() {
        return this._reuseStyle;
    }

    public boolean mustUnfoldWhenDone() {
        return this._unfoldWhenDone;
    }

    public void setDisplayWhenDone(boolean display_p) {
        this._displayWhenDone = display_p;
    }

    public void setMultiplicity(int multiplicity_p) {
        this._multiplicity = multiplicity_p;
    }

    public void setNumberOfApplications(int number_p) {
        this._numberOfApplications = number_p;
    }

    public void setNamingRule(String namingRule_p) {
        this._namingRule = namingRule_p;
    }

    @Override
    public void setPattern(TemplatePattern pattern_p) {
        EObject scopeElement = this._modelElements.get(0);
        this._application = pattern_p == null ? null : new BasicPatternApplication((IPattern)pattern_p, (Object)scopeElement);
        this._reuseLayout = pattern_p != null && !pattern_p.getLayoutData().isEmpty();
        this._reuseStyle = pattern_p != null && !pattern_p.getLayoutData().isEmpty();
        super.setPattern(pattern_p);
        if (this._application != null && this.applicationByAdditionEnabled(pattern_p)) {
            this.applyDefaultAssociation(this._application, this._modelElements);
        }
    }

    private boolean applicationByAdditionEnabled(TemplatePattern pattern_p) {
        for (TemplatePatternRole role : pattern_p.getRoles()) {
            if (role.acceptsAddition()) continue;
            return false;
        }
        return true;
    }

    public void setReuseLayout(boolean reuse_p) {
        this._reuseLayout = reuse_p;
    }

    public void setReuseStyle(boolean reuse_p) {
        this._reuseStyle = reuse_p;
    }

    public void setUnfoldWhenDone(boolean unfold_p) {
        this._unfoldWhenDone = unfold_p;
    }
}

