/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge;

import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IIdProvider;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractIdentifiedElement;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplateCounterpart;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;

public class TemplatePatternMatchPolicy
extends DefaultMatchPolicy {
    private final TemplatePatternApplicationComparison _applicationComparison;
    private EditingDomain _referenceEditingDomain;
    private EditingDomain _targetEditingDomain;

    public TemplatePatternMatchPolicy(TemplatePatternApplicationComparison applicationComparison_p, EditingDomain referenceEditingDomain_p, EditingDomain targetEditingDomain_p) {
        this._applicationComparison = applicationComparison_p;
        this._referenceEditingDomain = referenceEditingDomain_p;
        this._targetEditingDomain = targetEditingDomain_p;
    }

    private String getCurrentMultipart() {
        String result = null;
        if (this._applicationComparison != null) {
            result = this._applicationComparison.getCurrentMultipart();
        }
        return result;
    }

    public Object getMatchID(EObject element_p, IModelScope scope_p) {
        EditingDomain currentEditingDomain = null;
        if (EcoreUtil.getRootContainer((EObject)element_p) instanceof AbstractIdentifiedElement) {
            currentEditingDomain = this._referenceEditingDomain;
        }
        if (currentEditingDomain == null) {
            currentEditingDomain = this._targetEditingDomain;
        }
        IIdProvider idProvider = CorePatternsPlugin.getDefault().getIdProvider();
        String result = idProvider.getId(element_p, currentEditingDomain);
        TemplatePatternData data = null;
        if (this._applicationComparison != null) {
            data = this._applicationComparison.getPatternData();
        }
        if (data != null) {
            EObject instanceElement;
            ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(element_p);
            TemplateCounterpart templateCounterpart = (TemplateCounterpart)data.getTemplateIds().get((Object)result);
            if (templateCounterpart != null) {
                EObject instanceElement2;
                String instanceId = null;
                String multipart = this.getCurrentMultipart();
                if (multipart != null) {
                    instanceId = (String)templateCounterpart.getInstanceParts().get((Object)multipart);
                }
                if (instanceId == null) {
                    instanceId = (String)templateCounterpart.getInstanceParts().get((Object)this._applicationComparison.getMainMultipart());
                }
                if (instanceId != null) {
                    result = instanceId;
                } else if (ruleProvider.canBeAutomaticallyMerged(element_p) && (instanceElement2 = ruleProvider.getAutomaticMergeTarget(element_p, currentEditingDomain)) != null) {
                    result = idProvider.getId(instanceElement2, currentEditingDomain);
                }
            } else if (ruleProvider.canBeAutomaticallyMerged(element_p) && (instanceElement = ruleProvider.getAutomaticMergeTarget(element_p, currentEditingDomain)) != null) {
                result = idProvider.getId(instanceElement, currentEditingDomain);
            }
        }
        return result;
    }
}

