/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.diffdata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.diffdata.DiffdataPackage;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMergeableDifference;
import org.eclipse.emf.diffmerge.diffdata.impl.EIdentifiedImpl;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.endo.AbstractEndorelation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public abstract class EMergeableDifferenceImpl
extends EIdentifiedImpl
implements EMergeableDifference {
    protected EComparison comparison;
    protected static final boolean ALIGNED_WITH_ANCESTOR_EDEFAULT = true;
    protected boolean alignedWithAncestor = true;
    protected static final boolean CONFLICTING_EDEFAULT = false;
    protected boolean conflicting = false;
    protected static final boolean IGNORED_EDEFAULT = false;
    protected boolean ignored = false;
    protected static final Role MERGE_DESTINATION_EDEFAULT = null;
    protected Role mergeDestination = MERGE_DESTINATION_EDEFAULT;
    protected EList<Role> possibleMergeDestinations;
    protected EList<IMergeableDifference> explicitDependenciesForTarget;
    protected EList<IMergeableDifference> explicitDependenciesForReference;
    protected EList<IMergeableDifference> implicitDependenciesForTarget;
    protected EList<IMergeableDifference> implicitDependenciesForReference;
    private transient Collection<IMergeableDifference> _allImplicitDependenciesTarget = null;
    private transient Collection<IMergeableDifference> _allImplicitDependenciesReference = null;
    private transient Collection<IMergeableDifference> _allExplicitDependenciesTarget = null;
    private transient Collection<IMergeableDifference> _allExplicitDependenciesReference = null;

    protected EMergeableDifferenceImpl() {
        this(true);
    }

    protected EMergeableDifferenceImpl(boolean deferInit_p) {
        if (!deferInit_p) {
            this.getPossibleMergeDestinations().add((Object)Role.TARGET);
            this.getPossibleMergeDestinations().add((Object)Role.REFERENCE);
        }
    }

    @Override
    protected EClass eStaticClass() {
        return DiffdataPackage.Literals.EMERGEABLE_DIFFERENCE;
    }

    @Override
    public EComparison getComparison() {
        if (this.comparison != null && this.comparison.eIsProxy()) {
            InternalEObject oldComparison = (InternalEObject)this.comparison;
            this.comparison = (EComparison)this.eResolveProxy(oldComparison);
            if (this.comparison != oldComparison && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldComparison, (Object)this.comparison));
            }
        }
        return this.comparison;
    }

    public EComparison basicGetComparison() {
        return this.comparison;
    }

    @Override
    public void setComparison(EComparison newComparison) {
        EComparison oldComparison = this.comparison;
        this.comparison = newComparison;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldComparison, (Object)this.comparison));
        }
    }

    @Override
    public boolean isAlignedWithAncestor() {
        return this.alignedWithAncestor;
    }

    @Override
    public void setAlignedWithAncestor(boolean newAlignedWithAncestor) {
        boolean oldAlignedWithAncestor = this.alignedWithAncestor;
        this.alignedWithAncestor = newAlignedWithAncestor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldAlignedWithAncestor, this.alignedWithAncestor));
        }
    }

    @Override
    public boolean isConflicting() {
        return this.conflicting;
    }

    @Override
    public void setConflicting(boolean newConflicting) {
        boolean oldConflicting = this.conflicting;
        this.conflicting = newConflicting;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldConflicting, this.conflicting));
        }
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    @Override
    public void setIgnored(boolean newIgnored) {
        boolean oldIgnored = this.ignored;
        this.ignored = newIgnored;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldIgnored, this.ignored));
        }
    }

    @Override
    public Role getMergeDestination() {
        return this.mergeDestination;
    }

    @Override
    public void setMergeDestination(Role newMergeDestination) {
        Role oldMergeDestination = this.mergeDestination;
        this.mergeDestination = newMergeDestination;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldMergeDestination, (Object)this.mergeDestination));
        }
    }

    @Override
    public EList<Role> getPossibleMergeDestinations() {
        if (this.possibleMergeDestinations == null) {
            this.possibleMergeDestinations = new EDataTypeUniqueEList(Role.class, (InternalEObject)this, 6);
        }
        return this.possibleMergeDestinations;
    }

    @Override
    public EList<IMergeableDifference> getExplicitDependenciesForTarget() {
        if (this.explicitDependenciesForTarget == null) {
            this.explicitDependenciesForTarget = new EObjectResolvingEList(IMergeableDifference.class, (InternalEObject)this, 7);
        }
        return this.explicitDependenciesForTarget;
    }

    @Override
    public EList<IMergeableDifference> getExplicitDependenciesForReference() {
        if (this.explicitDependenciesForReference == null) {
            this.explicitDependenciesForReference = new EObjectResolvingEList(IMergeableDifference.class, (InternalEObject)this, 8);
        }
        return this.explicitDependenciesForReference;
    }

    @Override
    public EList<IMergeableDifference> getImplicitDependenciesForTarget() {
        if (this.implicitDependenciesForTarget == null) {
            this.implicitDependenciesForTarget = new EObjectResolvingEList(IMergeableDifference.class, (InternalEObject)this, 9);
        }
        return this.implicitDependenciesForTarget;
    }

    @Override
    public EList<IMergeableDifference> getImplicitDependenciesForReference() {
        if (this.implicitDependenciesForReference == null) {
            this.implicitDependenciesForReference = new EObjectResolvingEList(IMergeableDifference.class, (InternalEObject)this, 10);
        }
        return this.implicitDependenciesForReference;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                if (resolve) {
                    return this.getComparison();
                }
                return this.basicGetComparison();
            }
            case 2: {
                return this.isAlignedWithAncestor();
            }
            case 3: {
                return this.isConflicting();
            }
            case 4: {
                return this.isIgnored();
            }
            case 5: {
                return this.getMergeDestination();
            }
            case 6: {
                return this.getPossibleMergeDestinations();
            }
            case 7: {
                return this.getExplicitDependenciesForTarget();
            }
            case 8: {
                return this.getExplicitDependenciesForReference();
            }
            case 9: {
                return this.getImplicitDependenciesForTarget();
            }
            case 10: {
                return this.getImplicitDependenciesForReference();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setComparison((EComparison)newValue);
                return;
            }
            case 2: {
                this.setAlignedWithAncestor((Boolean)newValue);
                return;
            }
            case 3: {
                this.setConflicting((Boolean)newValue);
                return;
            }
            case 4: {
                this.setIgnored((Boolean)newValue);
                return;
            }
            case 5: {
                this.setMergeDestination((Role)((Object)newValue));
                return;
            }
            case 6: {
                this.getPossibleMergeDestinations().clear();
                this.getPossibleMergeDestinations().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getExplicitDependenciesForTarget().clear();
                this.getExplicitDependenciesForTarget().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getExplicitDependenciesForReference().clear();
                this.getExplicitDependenciesForReference().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getImplicitDependenciesForTarget().clear();
                this.getImplicitDependenciesForTarget().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getImplicitDependenciesForReference().clear();
                this.getImplicitDependenciesForReference().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setComparison(null);
                return;
            }
            case 2: {
                this.setAlignedWithAncestor(true);
                return;
            }
            case 3: {
                this.setConflicting(false);
                return;
            }
            case 4: {
                this.setIgnored(false);
                return;
            }
            case 5: {
                this.setMergeDestination(MERGE_DESTINATION_EDEFAULT);
                return;
            }
            case 6: {
                this.getPossibleMergeDestinations().clear();
                return;
            }
            case 7: {
                this.getExplicitDependenciesForTarget().clear();
                return;
            }
            case 8: {
                this.getExplicitDependenciesForReference().clear();
                return;
            }
            case 9: {
                this.getImplicitDependenciesForTarget().clear();
                return;
            }
            case 10: {
                this.getImplicitDependenciesForReference().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.comparison != null;
            }
            case 2: {
                return !this.alignedWithAncestor;
            }
            case 3: {
                return this.conflicting;
            }
            case 4: {
                return this.ignored;
            }
            case 5: {
                return MERGE_DESTINATION_EDEFAULT == null ? this.mergeDestination != null : !MERGE_DESTINATION_EDEFAULT.equals((Object)this.mergeDestination);
            }
            case 6: {
                return this.possibleMergeDestinations != null && !this.possibleMergeDestinations.isEmpty();
            }
            case 7: {
                return this.explicitDependenciesForTarget != null && !this.explicitDependenciesForTarget.isEmpty();
            }
            case 8: {
                return this.explicitDependenciesForReference != null && !this.explicitDependenciesForReference.isEmpty();
            }
            case 9: {
                return this.implicitDependenciesForTarget != null && !this.implicitDependenciesForTarget.isEmpty();
            }
            case 10: {
                return this.implicitDependenciesForReference != null && !this.implicitDependenciesForReference.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (alignedWithAncestor: ");
        result.append(this.alignedWithAncestor);
        result.append(", conflicting: ");
        result.append(this.conflicting);
        result.append(", ignored: ");
        result.append(this.ignored);
        result.append(", mergeDestination: ");
        result.append((Object)this.mergeDestination);
        result.append(", possibleMergeDestinations: ");
        result.append(this.possibleMergeDestinations);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean canMergeTo(Role destination_p) {
        return this.getPossibleMergeDestinations().contains((Object)destination_p);
    }

    protected void checkMerge(IMergeableDifference difference_p, Role destination_p) {
        if (this.getMergeDestination() != destination_p && !this.canMergeTo(destination_p)) {
            throw new UnsupportedOperationException(String.valueOf(Messages.AbstractDifference_UnableToMerge) + ": " + this.toString());
        }
    }

    @Override
    public abstract void doMergeIn(Role var1);

    protected final void forbidMergeTo(Role destination_p) {
        if (destination_p != null) {
            this.getPossibleMergeDestinations().remove((Object)destination_p);
        }
    }

    @Override
    public final Collection<IMergeableDifference> getDirectImpliesDependencies(Role role_p) {
        Collection<Object> result;
        switch (role_p) {
            case TARGET: {
                EList<IMergeableDifference> obtained = this.getImplicitDependenciesForTarget(false);
                if (obtained == null) {
                    result = Collections.emptyList();
                    break;
                }
                result = Collections.unmodifiableCollection(obtained);
                break;
            }
            default: {
                EList<IMergeableDifference> obtained = this.getImplicitDependenciesForReference(false);
                result = obtained == null ? Collections.emptyList() : Collections.unmodifiableCollection(obtained);
            }
        }
        return result;
    }

    @Override
    public final Collection<IMergeableDifference> getDirectRequiresDependencies(Role role_p) {
        Collection<Object> result;
        switch (role_p) {
            case TARGET: {
                EList<IMergeableDifference> obtained = this.getExplicitDependenciesForTarget(false);
                if (obtained == null) {
                    result = Collections.emptyList();
                    break;
                }
                result = Collections.unmodifiableCollection(obtained);
                break;
            }
            default: {
                EList<IMergeableDifference> obtained = this.getExplicitDependenciesForReference(false);
                result = obtained == null ? Collections.emptyList() : Collections.unmodifiableCollection(obtained);
            }
        }
        return result;
    }

    public EList<IMergeableDifference> getExplicitDependenciesForReference(boolean create_p) {
        return create_p ? this.getExplicitDependenciesForReference() : this.explicitDependenciesForReference;
    }

    public EList<IMergeableDifference> getImplicitDependenciesForReference(boolean create_p) {
        return create_p ? this.getImplicitDependenciesForReference() : this.implicitDependenciesForReference;
    }

    public EList<IMergeableDifference> getExplicitDependenciesForTarget(boolean create_p) {
        return create_p ? this.getExplicitDependenciesForTarget() : this.explicitDependenciesForTarget;
    }

    public EList<IMergeableDifference> getImplicitDependenciesForTarget(boolean create_p) {
        return create_p ? this.getImplicitDependenciesForTarget() : this.implicitDependenciesForTarget;
    }

    @Override
    public final Collection<IMergeableDifference> getImpliesDependencies(Role role_p) {
        List result;
        Collection<Object> collection = result = role_p == Role.TARGET ? this._allImplicitDependenciesTarget : this._allImplicitDependenciesReference;
        if (result == null) {
            Collection<IMergeableDifference> required = this.getRequiresDependencies(role_p);
            FArrayList allRequired = new FArrayList(required.size() + 1, null);
            allRequired.add(this);
            allRequired.addAll(required);
            result = new DifferenceDependencyRelation(role_p, false).getTransitiveClosure((Collection)allRequired);
            if (role_p == Role.TARGET) {
                this._allImplicitDependenciesTarget = result;
            } else {
                this._allImplicitDependenciesReference = result;
            }
        }
        return result;
    }

    @Override
    public final Collection<IMergeableDifference> getRequiresDependencies(Role role_p) {
        List result;
        Collection<Object> collection = result = role_p == Role.TARGET ? this._allExplicitDependenciesTarget : this._allExplicitDependenciesReference;
        if (result == null) {
            result = new DifferenceDependencyRelation(role_p, true).getTransitiveClosure(this);
            if (role_p == Role.TARGET) {
                this._allExplicitDependenciesTarget = result;
            } else {
                this._allExplicitDependenciesReference = result;
            }
        }
        return result;
    }

    @Override
    public final boolean isMerged() {
        return this.getMergeDestination() != null;
    }

    @Override
    public Collection<IDifference> mergeTo(Role destination_p) {
        this.checkMerge(this, destination_p);
        if (this.isMerged()) {
            return Collections.emptyList();
        }
        Collection<IMergeableDifference> allRequired = this.getRequiresDependencies(destination_p);
        for (IMergeableDifference required : allRequired) {
            this.checkMerge(required, destination_p);
        }
        this.markAsMergedIn(destination_p);
        HashSet<IMergeableDifference> result = new HashSet<IMergeableDifference>();
        for (IMergeableDifference required : allRequired) {
            if (required.isMerged()) continue;
            ((IMergeableDifference.Editable)required).markAsMergedIn(destination_p);
            ((IMergeableDifference.Editable)required).doMergeIn(destination_p);
            result.add(required);
        }
        this.doMergeIn(destination_p);
        result.add(this);
        for (IMergeableDifference implicit : this.getImpliesDependencies(destination_p)) {
            if (implicit.isMerged()) continue;
            ((IMergeableDifference.Editable)implicit).markAsMergedIn(destination_p);
            result.add(implicit);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public void markAsConflicting() {
        this.markAsDifferentFromAncestor();
        this.setConflicting(true);
    }

    @Override
    public void markAsDifferentFromAncestor() {
        this.setAlignedWithAncestor(false);
    }

    @Override
    public void markAsMergedIn(Role destination_p) {
        if (this.getMergeDestination() == null) {
            this.setMergeDestination(destination_p);
            this.getPossibleMergeDestinations().clear();
        }
    }

    @Override
    public final void markImplies(IMergeableDifference difference_p, Role role_p) {
        EList<IMergeableDifference> toChange;
        switch (role_p) {
            case TARGET: {
                toChange = this.getImplicitDependenciesForTarget(true);
                break;
            }
            default: {
                toChange = this.getImplicitDependenciesForReference(true);
            }
        }
        if (!toChange.contains(difference_p)) {
            toChange.add(difference_p);
        }
    }

    @Override
    public final void markRequires(IMergeableDifference difference_p, Role role_p) {
        EList<IMergeableDifference> toChange;
        switch (role_p) {
            case TARGET: {
                toChange = this.getExplicitDependenciesForTarget(true);
                break;
            }
            default: {
                toChange = this.getExplicitDependenciesForReference(true);
            }
        }
        if (!toChange.contains(difference_p)) {
            toChange.add(difference_p);
        }
    }

    protected static class DifferenceDependencyRelation
    extends AbstractEndorelation<IMergeableDifference> {
        private final Role _role;
        private final boolean _isExplicit;

        protected DifferenceDependencyRelation(Role role_p, boolean isExplicit_p) {
            super(IEqualityTester.BY_REFERENCE);
            this._role = role_p;
            this._isExplicit = isExplicit_p;
        }

        public Collection<IMergeableDifference> get(IMergeableDifference element_p) {
            FHashSet result;
            if (this._isExplicit) {
                result = new FHashSet(element_p.getDirectRequiresDependencies(this._role), IEqualityTester.BY_REFERENCE);
                for (IMergeableDifference implicit : element_p.getDirectImpliesDependencies(this._role)) {
                    result.addAll(implicit.getDirectRequiresDependencies(this._role));
                }
            } else {
                result = element_p.getDirectImpliesDependencies(this._role);
            }
            return result;
        }
    }
}

