/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ReplicatedJob;

final class ImmutableReplicatedJob
implements ReplicatedJob {
    @Nullable
    private final Long maxConcurrent;
    @Nullable
    private final Long totalCompletions;

    private ImmutableReplicatedJob(@Nullable Long maxConcurrent, @Nullable Long totalCompletions) {
        this.maxConcurrent = maxConcurrent;
        this.totalCompletions = totalCompletions;
    }

    @Override
    @JsonProperty(value="MaxConcurrent")
    @Nullable
    public Long maxConcurrent() {
        return this.maxConcurrent;
    }

    @Override
    @JsonProperty(value="TotalCompletions")
    @Nullable
    public Long totalCompletions() {
        return this.totalCompletions;
    }

    public final ImmutableReplicatedJob withMaxConcurrent(@Nullable Long value) {
        if (Objects.equals(this.maxConcurrent, value)) {
            return this;
        }
        return new ImmutableReplicatedJob(value, this.totalCompletions);
    }

    public final ImmutableReplicatedJob withTotalCompletions(@Nullable Long value) {
        if (Objects.equals(this.totalCompletions, value)) {
            return this;
        }
        return new ImmutableReplicatedJob(this.maxConcurrent, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplicatedJob && this.equalsByValue((ImmutableReplicatedJob)another);
    }

    private boolean equalsByValue(ImmutableReplicatedJob another) {
        return Objects.equals(this.maxConcurrent, another.maxConcurrent) && Objects.equals(this.totalCompletions, another.totalCompletions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.maxConcurrent);
        h += (h << 5) + Objects.hashCode(this.totalCompletions);
        return h;
    }

    public String toString() {
        return "ReplicatedJob{maxConcurrent=" + this.maxConcurrent + ", totalCompletions=" + this.totalCompletions + "}";
    }

    public static ImmutableReplicatedJob copyOf(ReplicatedJob instance) {
        if (instance instanceof ImmutableReplicatedJob) {
            return (ImmutableReplicatedJob)instance;
        }
        return ImmutableReplicatedJob.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ReplicatedJob.Builder {
        private Long maxConcurrent;
        private Long totalCompletions;

        private Builder() {
        }

        public final Builder from(ReplicatedJob instance) {
            Long totalCompletionsValue;
            Objects.requireNonNull(instance, "instance");
            Long maxConcurrentValue = instance.maxConcurrent();
            if (maxConcurrentValue != null) {
                this.maxConcurrent(maxConcurrentValue);
            }
            if ((totalCompletionsValue = instance.totalCompletions()) != null) {
                this.totalCompletions(totalCompletionsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="MaxConcurrent")
        public final Builder maxConcurrent(@Nullable Long maxConcurrent) {
            this.maxConcurrent = maxConcurrent;
            return this;
        }

        @Override
        @JsonProperty(value="TotalCompletions")
        public final Builder totalCompletions(@Nullable Long totalCompletions) {
            this.totalCompletions = totalCompletions;
            return this;
        }

        @Override
        public ImmutableReplicatedJob build() {
            return new ImmutableReplicatedJob(this.maxConcurrent, this.totalCompletions);
        }
    }
}

