/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataManager
extends Lifecycle
implements IMetaDataManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, MetaDataManager.class);
    private static Map<EClassifier, DBType> typeMap = new HashMap<EClassifier, DBType>();
    private static final boolean ZIP_PACKAGE_BYTES = true;
    private IDBStore store;

    static {
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDate(), DBType.TIMESTAMP);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEString(), DBType.VARCHAR);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteArray(), DBType.BLOB);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), DBType.BOOLEAN);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByte(), DBType.SMALLINT);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEChar(), DBType.CHAR);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDouble(), DBType.DOUBLE);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloat(), DBType.FLOAT);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEInt(), DBType.INTEGER);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getELong(), DBType.BIGINT);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEShort(), DBType.SMALLINT);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), DBType.BOOLEAN);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteObject(), DBType.SMALLINT);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), DBType.CHAR);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), DBType.DOUBLE);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), DBType.FLOAT);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), DBType.INTEGER);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getELongObject(), DBType.BIGINT);
        typeMap.put((EClassifier)EcorePackage.eINSTANCE.getEShortObject(), DBType.SMALLINT);
    }

    public MetaDataManager(IDBStore store) {
        this.store = store;
    }

    @Override
    public long getMetaID(EModelElement modelElement) {
        CDOID cdoid = this.getPackageRegistry().getMetaInstanceMapper().lookupMetaInstanceID((InternalEObject)modelElement);
        return CDOIDUtil.getLong((CDOID)cdoid);
    }

    @Override
    public EModelElement getMetaInstance(long id) {
        CDOIDMeta cdoid = CDOIDUtil.createMeta((long)id);
        InternalEObject metaInstance = this.getPackageRegistry().getMetaInstanceMapper().lookupMetaInstance((CDOID)cdoid);
        return (EModelElement)metaInstance;
    }

    @Override
    public final EPackage[] loadPackageUnit(Connection connection, InternalCDOPackageUnit packageUnit) {
        String where = String.valueOf(CDODBSchema.PACKAGE_UNITS_ID.getName()) + "='" + packageUnit.getID() + "'";
        Object[] values = DBUtil.select((Connection)connection, (String)where, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_UNITS_PACKAGE_DATA});
        byte[] bytes = (byte[])values[0];
        EPackage ePackage = this.createEPackage(packageUnit, bytes);
        return EMFUtil.getAllPackages((EPackage)ePackage);
    }

    @Override
    public Collection<InternalCDOPackageUnit> readPackageUnits(Connection connection) {
        final HashMap packageUnits = new HashMap();
        IDBRowHandler unitRowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                InternalCDOPackageUnit packageUnit = MetaDataManager.this.createPackageUnit();
                packageUnit.setOriginalType(CDOPackageUnit.Type.values()[(Integer)values[1]]);
                packageUnit.setTimeStamp(((Long)values[2]).longValue());
                packageUnits.put((String)values[0], packageUnit);
                return true;
            }
        };
        DBUtil.select((Connection)connection, (IDBRowHandler)unitRowHandler, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_UNITS_ID, CDODBSchema.PACKAGE_UNITS_ORIGINAL_TYPE, CDODBSchema.PACKAGE_UNITS_TIME_STAMP});
        final HashMap packageInfos = new HashMap();
        IDBRowHandler infoRowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                long metaLB = (Long)values[3];
                long metaUB = (Long)values[4];
                CDOIDMetaRange metaIDRange = metaLB == 0L ? null : CDOIDUtil.createMetaRange((CDOID)CDOIDUtil.createMeta((long)metaLB), (int)((int)(metaUB - metaLB) + 1));
                InternalCDOPackageInfo packageInfo = MetaDataManager.this.createPackageInfo();
                packageInfo.setPackageURI((String)values[1]);
                packageInfo.setParentURI((String)values[2]);
                packageInfo.setMetaIDRange(metaIDRange);
                String unit = (String)values[0];
                ArrayList<InternalCDOPackageInfo> list = (ArrayList<InternalCDOPackageInfo>)packageInfos.get(unit);
                if (list == null) {
                    list = new ArrayList<InternalCDOPackageInfo>();
                    packageInfos.put(unit, list);
                }
                list.add(packageInfo);
                return true;
            }
        };
        DBUtil.select((Connection)connection, (IDBRowHandler)infoRowHandler, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_INFOS_UNIT, CDODBSchema.PACKAGE_INFOS_URI, CDODBSchema.PACKAGE_INFOS_PARENT, CDODBSchema.PACKAGE_INFOS_META_LB, CDODBSchema.PACKAGE_INFOS_META_UB});
        for (Map.Entry entry : packageUnits.entrySet()) {
            String id = (String)entry.getKey();
            InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)entry.getValue();
            List list = (List)packageInfos.get(id);
            InternalCDOPackageInfo[] array = list.toArray(new InternalCDOPackageInfo[list.size()]);
            packageUnit.setPackageInfos(array);
        }
        return packageUnits.values();
    }

    @Override
    public final void writePackageUnits(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        try {
            monitor.begin(2.0);
            this.fillSystemTables(connection, packageUnits, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public DBType getDBType(EClassifier type) {
        if (type instanceof EClass) {
            return DBType.BIGINT;
        }
        if (type instanceof EEnum) {
            return DBType.INTEGER;
        }
        DBType dbType = typeMap.get(type);
        if (dbType != null) {
            return dbType;
        }
        return DBType.VARCHAR;
    }

    protected IDBStore getStore() {
        return this.store;
    }

    protected void doBeforeActivate() throws Exception {
        this.checkState(this.store != null, "Store is not set");
    }

    protected InternalCDOPackageInfo createPackageInfo() {
        return (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
    }

    protected InternalCDOPackageUnit createPackageUnit() {
        return (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
    }

    private InternalCDOPackageRegistry getPackageRegistry() {
        return (InternalCDOPackageRegistry)this.store.getRepository().getPackageRegistry();
    }

    private EPackage createEPackage(InternalCDOPackageUnit packageUnit, byte[] bytes) {
        return EMFUtil.createEPackage((String)packageUnit.getID(), (byte[])bytes, (boolean)true, (EPackage.Registry)this.getPackageRegistry());
    }

    private byte[] getEPackageBytes(InternalCDOPackageUnit packageUnit) {
        EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
        CDOPackageRegistry packageRegistry = this.getStore().getRepository().getPackageRegistry();
        return EMFUtil.getEPackageBytes((EPackage)ePackage, (boolean)true, (EPackage.Registry)packageRegistry);
    }

    private void fillSystemTables(Connection connection, InternalCDOPackageUnit packageUnit, OMMonitor monitor) {
        try {
            InternalCDOPackageInfo[] packageInfos = packageUnit.getPackageInfos();
            monitor.begin((double)(1 + packageInfos.length));
            if (TRACER.isEnabled()) {
                TRACER.format("Writing package unit: {0}", new Object[]{packageUnit});
            }
            String sql = "INSERT INTO " + CDODBSchema.PACKAGE_UNITS + " VALUES (?, ?, ?, ?)";
            DBUtil.trace((String)sql);
            PreparedStatement pstmt = null;
            OMMonitor.Async async = monitor.forkAsync();
            try {
                try {
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, packageUnit.getID());
                    pstmt.setInt(2, packageUnit.getOriginalType().ordinal());
                    pstmt.setLong(3, packageUnit.getTimeStamp());
                    pstmt.setBytes(4, this.getEPackageBytes(packageUnit));
                    if (pstmt.execute()) {
                        throw new DBException("No result set expected");
                    }
                    if (pstmt.getUpdateCount() == 0) {
                        throw new DBException("No row inserted into table " + CDODBSchema.PACKAGE_UNITS);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(pstmt);
                async.stop();
                throw throwable;
            }
            DBUtil.close((Statement)pstmt);
            async.stop();
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
            int n = packageInfos.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                this.fillSystemTables(connection, packageInfo, monitor);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fillSystemTables(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        try {
            monitor.begin((double)packageUnits.length);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.fillSystemTables(connection, packageUnit, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fillSystemTables(Connection connection, InternalCDOPackageInfo packageInfo, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing package info: {0}", new Object[]{packageInfo});
        }
        String packageURI = packageInfo.getPackageURI();
        String parentURI = packageInfo.getParentURI();
        String unitID = packageInfo.getPackageUnit().getID();
        CDOIDMetaRange metaIDRange = packageInfo.getMetaIDRange();
        long metaLB = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getLowerBound()).getLongValue();
        long metaUB = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getUpperBound()).getLongValue();
        String sql = "INSERT INTO " + CDODBSchema.PACKAGE_INFOS + " VALUES (?, ?, ?, ?, ?)";
        DBUtil.trace((String)sql);
        PreparedStatement pstmt = null;
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, packageURI);
                pstmt.setString(2, parentURI);
                pstmt.setString(3, unitID);
                pstmt.setLong(4, metaLB);
                pstmt.setLong(5, metaUB);
                if (pstmt.execute()) {
                    throw new DBException("No result set expected");
                }
                if (pstmt.getUpdateCount() == 0) {
                    throw new DBException("No row inserted into table " + CDODBSchema.PACKAGE_INFOS);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(pstmt);
            async.stop();
            throw throwable;
        }
        DBUtil.close((Statement)pstmt);
        async.stop();
    }
}

