/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.presentation;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class DelayedColumnFitter
extends ControlAdapter {
    protected Table table;
    protected DelayedLayout delayedLayout;
    protected int columnResizeTime;
    protected int oldWidth;
    protected boolean inLayout;

    DelayedColumnFitter() {
    }

    public void controlResized(ControlEvent event) {
        if (event.getSource() instanceof Table) {
            this.table = (Table)event.getSource();
            if (this.delayedLayout == null) {
                this.delayedLayout = new DelayedLayout(event.time);
            }
        } else if (!this.inLayout) {
            this.columnResizeTime = event.time;
        }
    }

    protected class DelayedLayout
    implements Runnable {
        protected TableLayout layout;
        protected int newWidth;
        protected boolean ignore;

        public DelayedLayout(int time) {
            this.newWidth = DelayedColumnFitter.this.table.getClientArea().width;
            if (DelayedColumnFitter.this.oldWidth != this.newWidth && DelayedColumnFitter.this.oldWidth != 0) {
                this.layout = new TableLayout();
                TableColumn[] tableColumns = DelayedColumnFitter.this.table.getColumns();
                int i = 0;
                while (i < tableColumns.length) {
                    this.layout.addColumnData((ColumnLayoutData)new ColumnWeightData(tableColumns[i].getWidth(), true));
                    ++i;
                }
                if (DelayedColumnFitter.this.columnResizeTime != 0 && time - DelayedColumnFitter.this.columnResizeTime < 500) {
                    this.ignore = true;
                }
            } else {
                this.ignore = true;
            }
            DelayedColumnFitter.this.oldWidth = this.newWidth;
            DelayedColumnFitter.this.columnResizeTime = 0;
            DelayedColumnFitter.this.table.getDisplay().asyncExec((Runnable)this);
        }

        public void run() {
            DelayedColumnFitter.this.delayedLayout = null;
            if (!DelayedColumnFitter.this.table.isDisposed() && !this.ignore) {
                DelayedColumnFitter.this.columnResizeTime = 0;
                DelayedColumnFitter.this.table.setLayout((Layout)this.layout);
                DelayedColumnFitter.this.inLayout = true;
                DelayedColumnFitter.this.table.layout();
                DelayedColumnFitter.this.inLayout = false;
            }
        }
    }
}

