/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.examples.library;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TWriterType implements Enumerator
{
    TYPEWRITER(0, "Typewriter", "Typewriter"),
    COMPUTER(1, "Computer", "Computer");

    public static final int TYPEWRITER_VALUE = 0;
    public static final int COMPUTER_VALUE = 1;
    private static final TWriterType[] VALUES_ARRAY;
    public static final List<TWriterType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TWriterType[]{TYPEWRITER, COMPUTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TWriterType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TWriterType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TWriterType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TWriterType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TWriterType get(int value) {
        switch (value) {
            case 0: {
                return TYPEWRITER;
            }
            case 1: {
                return COMPUTER;
            }
        }
        return null;
    }

    private TWriterType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

