/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.core.parser.ast.XMLElement;
import org.eclipse.jet.internal.JavaUtil;
import org.eclipse.jet.internal.compiler.SafeJETASTVisitor;

public class V2CodeGenVisitor
extends SafeJETASTVisitor {
    private static final String UNDERSCORE = "_";
    private final String textPrefix = "TEXT_";
    private final String tagVarPrefix = "_jettag_";
    private static final String NL_REGEX = "([\\n][\\r]?|[\\r][\\n]?)";
    private static final Pattern NL_PATTERN = Pattern.compile("([\\n][\\r]?|[\\r][\\n]?)", 8);
    private static final String NL = System.getProperty("line.separator");

    public V2CodeGenVisitor(JET2Context context, JET2Writer out, String stdIndent) {
        super(context, out, stdIndent);
    }

    public V2CodeGenVisitor(JET2Context context, JET2Writer out) {
        this(context, out, "    ");
    }

    public String tagVariableName(XMLElement element) {
        return this.tagVar(element);
    }

    public String tagVar(XMLElement element) {
        return "_jettag_" + this.tagVariableSuffix(element);
    }

    public String tagInfoVariableName(XMLElement element) {
        return this.tagInfoVar(element);
    }

    public String tagInfoVar(XMLElement element) {
        return this.tagVariableSuffix(element);
    }

    private String tagVariableSuffix(XMLElement element) {
        return String.valueOf(element.getNSPrefix()) + UNDERSCORE + element.getTagNCName() + UNDERSCORE + element.getLine() + UNDERSCORE + element.getColumn();
    }

    public String textVar(int i) {
        return "TEXT_" + i;
    }

    public boolean requiresOwnWriter(XMLElement element) {
        return element.getTagDefinition().requiresNewWriter();
    }

    public String parentTagVar(XMLElement element) {
        XMLElement parentXMLElement = null;
        JETASTElement astParent = element.getParent();
        while (astParent != null) {
            if (astParent instanceof XMLElement) {
                parentXMLElement = (XMLElement)astParent;
                break;
            }
            astParent = astParent.getParent();
        }
        return parentXMLElement == null ? "null" : this.tagVar(parentXMLElement);
    }

    public String textExpr(TextElement text) {
        return JavaUtil.asJavaQuoteStringWithNLRemoved(text.getText());
    }

    public String[] textConstants(TextElement text, String nlConstantName) {
        return JavaUtil.asJavaQuotedStrings(text.getText(), nlConstantName);
    }

    public String nlsComment(TextElement text) {
        return JavaUtil.nlsCommentsForJavaQuoteStringWithNLRemoved(text.getText());
    }

    protected boolean isClassComment(String comment) {
        String text = this.getFirstCommentLine(comment);
        return text.equals("@class");
    }

    protected boolean isHeaderComment(String comment) {
        String text = this.getFirstCommentLine(comment);
        return text.equals("@header");
    }

    protected boolean isNormalComment(String comment) {
        String text = this.getFirstCommentLine(comment);
        return !text.equals("@header") && !text.equals("@class");
    }

    protected String formatComment(String text, String leadIn) {
        if (!this.isNormalComment(text)) {
            text = text.replaceFirst("(?ms)^.*?$.*?^", "");
        }
        return V2CodeGenVisitor.indent(text, leadIn, 1);
    }

    private String getFirstCommentLine(String text) {
        Matcher matcher = NL_PATTERN.matcher(text = text.trim());
        String firstLine = matcher.find() ? text.substring(0, matcher.start()).trim() : text;
        return firstLine;
    }

    public static String indent(String content, String indent, int depth) {
        String line;
        String totalIndent = V2CodeGenVisitor.computeTotalIndent(indent, depth);
        if (totalIndent.length() == 0) {
            return content;
        }
        boolean indentIsWhitespace = totalIndent.matches("\\s*");
        Matcher matcher = NL_PATTERN.matcher(content);
        StringBuffer result = new StringBuffer(content.length() * 2);
        int lineStart = 0;
        while (matcher.find(lineStart)) {
            line = content.substring(lineStart, matcher.start());
            if (line.length() > 0 || !indentIsWhitespace) {
                result.append(totalIndent);
            }
            result.append(line);
            result.append(NL);
            lineStart = matcher.end();
            lineStart = matcher.end();
        }
        if (lineStart < content.length()) {
            line = content.substring(lineStart);
            result.append(totalIndent).append(line).append(NL);
        }
        return result.toString();
    }

    private static String computeTotalIndent(String indent, int depth) {
        StringBuffer buffer = new StringBuffer(depth * indent.length());
        if (indent != null) {
            int i = 0;
            while (i < depth) {
                buffer.append(indent);
                ++i;
            }
        }
        return buffer.toString();
    }
}

