/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.launch;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.launch.JETProcess;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.osgi.util.NLS;

public class JET2TransformationDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate,
ILaunchConfigurationDelegate2 {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String id = this.getId(configuration);
        IResource source = this.getSource(configuration);
        int logFilterLevel = this.getLogFilterLevel(configuration);
        JETProcess process = new JETProcess(launch, id, source, logFilterLevel, monitor);
        launch.addProcess((IProcess)process);
        process.run();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getReferencedWorkspaceProjects(configuration);
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getReferencedWorkspaceProjects(configuration);
    }

    private IProject[] getReferencedWorkspaceProjects(ILaunchConfiguration configuration) throws CoreException {
        LinkedList projects = new LinkedList();
        this.internalGetReferencedProjects(this.getId(configuration), projects, new HashSet());
        return projects.toArray(new IProject[projects.size()]);
    }

    private IProject getJETProject(String id) {
        String projectName = JET2Platform.getJETBundleManager().getProjectForId(id);
        IProject project = projectName != null ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
        return project;
    }

    private void internalGetReferencedProjects(String id, List projects, Set knownIds) {
        String overridesId;
        if (knownIds.contains(id)) {
            return;
        }
        knownIds.add(id);
        IJETBundleDescriptor descriptor = JET2Platform.getJETBundleManager().getDescriptor(id);
        IProject jetProject = this.getJETProject(id);
        if (jetProject != null) {
            projects.add(jetProject);
        }
        if ((overridesId = descriptor.getOverridesId()) != null) {
            this.internalGetReferencedProjects(overridesId, projects, knownIds);
        }
    }

    private IResource getSource(ILaunchConfiguration configuration) throws CoreException {
        String sourcePath = configuration.getAttribute("org.eclipse.jet.source", null);
        if (sourcePath == null) {
            Status status = new Status(4, "org.eclipse.jet", NLS.bind((String)JET2Messages.JET2TransformationDelegate_MissingAttribute, (Object)"org.eclipse.jet.source", (Object)configuration.getName()));
            throw new CoreException((IStatus)status);
        }
        Path path = new Path(sourcePath);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = wsRoot.findMember((IPath)path);
        if (resource == null) {
            resource = path.segmentCount() == 1 ? wsRoot.getProject(path.segment(0)) : wsRoot.getFile((IPath)path);
        }
        return resource;
    }

    private String getId(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("org.eclipse.jet.id", null);
        if (id == null) {
            Status status = new Status(4, "org.eclipse.jet", NLS.bind((String)JET2Messages.JET2TransformationDelegate_MissingAttribute, (Object)"org.eclipse.jet.id", (Object)configuration.getName()));
            throw new CoreException((IStatus)status);
        }
        return id;
    }

    private int getLogFilterLevel(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.jet.logFilterLevel", 3);
    }
}

