/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.core.IModelManager;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.core.internal.XtendXpandProject;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class XtendXpandModelManager
implements IModelManager {
    public final Cache<IJavaProject, XtendXpandProject> projects = new Cache<IJavaProject, XtendXpandProject>(){

        protected XtendXpandProject createNew(IJavaProject ele) {
            return new XtendXpandProject(ele);
        }
    };

    public IXtendXpandProject findProject(IPath path) {
        return this.findProject(ResourcesPlugin.getWorkspace().getRoot().findMember(path));
    }

    public IXtendXpandProject findProject(IResource res) {
        if (res == null) {
            return null;
        }
        IJavaProject ele = JavaCore.create((IProject)res.getProject());
        try {
            if (ele != null && res.getProject().isAccessible() && res.getProject().isNatureEnabled(XtendXpandNature.NATURE_ID)) {
                return (IXtendXpandProject)this.projects.get((Object)ele);
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return null;
    }

    public void analyze(IProgressMonitor monitor) {
        monitor.beginTask(Messages.XtendXpandModelManager_AnalyzingPrompt, this.computeAmoutOfWork());
        Iterator iter = this.projects.getValues().iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            IXtendXpandProject project = (IXtendXpandProject)iter.next();
            project.analyze(monitor, Activator.getExecutionContext(project.getProject()));
        }
        monitor.done();
    }

    private int computeAmoutOfWork() {
        int i = 0;
        for (IXtendXpandProject element : this.projects.getValues()) {
            i += element.getRegisteredResources().length;
        }
        return i;
    }

    public IXtendXpandResource findExtXptResource(IStorage file) {
        if (!(file instanceof IFile)) {
            for (IXtendXpandProject p : this.projects.getValues()) {
                IXtendXpandResource res = p.findXtendXpandResource(file);
                if (res == null) continue;
                return res;
            }
        } else {
            IXtendXpandProject project = this.findProject((IResource)((IFile)file));
            if (project != null) {
                return project.findXtendXpandResource(file);
            }
        }
        return null;
    }

    public IXtendXpandResource findXtendXpandResource(String oawNamespace, String extension) {
        for (IXtendXpandProject p : this.projects.getValues()) {
            IXtendXpandResource res = p.findExtXptResource(oawNamespace, extension);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

