/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.runtime.model.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class EntityResolverFactory {
    private static boolean initialized = false;
    private static URIResolverProxy uriResolver;
    static /* synthetic */ Class class$0;

    public static EntityResolver getEntityResolver(String baseLocation) {
        EntityResolverFactory.initURIResolver();
        return uriResolver != null ? new WSTEntityResolver(baseLocation, uriResolver) : new DefaultEntityResolver(null, null);
    }

    private static void initURIResolver() {
        if (!initialized) {
            initialized = true;
            try {
                uriResolver = new URIResolverPluginClassProxy().createResolver();
            }
            catch (SecurityException e) {
                InternalJET2Platform.logError("Error initializing access to WST URIResolver", e);
            }
            catch (IllegalArgumentException e) {
                InternalJET2Platform.logError("Error initializing access to WST URIResolver", e);
            }
            catch (NoSuchMethodException e) {
                InternalJET2Platform.logError("Error initializing access to WST URIResolver", e);
            }
            catch (IllegalAccessException e) {
                InternalJET2Platform.logError("Error initializing access to WST URIResolver", e);
            }
            catch (InvocationTargetException e) {
                InternalJET2Platform.logError("Error initializing access to WST URIResolver", e);
            }
            catch (BundleException bundleException) {
            }
            catch (ClassNotFoundException e) {
                InternalJET2Platform.logError("Error initializing access to WST URIResolver", e);
            }
        }
    }

    private static class DefaultEntityResolver
    implements EntityResolver {
        private DefaultEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputStream stream;
            URL systemURL = new URL(systemId);
            try {
                stream = systemURL.openStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException(NLS.bind((String)Messages.EntityResolverFactory_FileNotFound, (Object)publicId, (Object)systemId));
            }
            return new InputSource(stream);
        }

        /* synthetic */ DefaultEntityResolver(DefaultEntityResolver defaultEntityResolver, DefaultEntityResolver defaultEntityResolver2) {
            this();
        }
    }

    private static final class URIResolverPluginClassProxy {
        private static final String WST_URIRESOLVER_PLUGIN_CLASS = "org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin";
        private static final String WST_URIRESOLVER_PLUGIN_ID = "org.eclipse.wst.common.uriresolver";
        private final Class pluginClass;
        private final Method createResolverMethod;

        public URIResolverPluginClassProxy() throws BundleException, ClassNotFoundException, SecurityException, NoSuchMethodException {
            Bundle bundle = Platform.getBundle((String)WST_URIRESOLVER_PLUGIN_ID);
            if (bundle == null) {
                throw new BundleException(NLS.bind((String)Messages.EntityResolverFactory_BundleNotResolved, (Object)WST_URIRESOLVER_PLUGIN_ID));
            }
            this.pluginClass = bundle.loadClass(WST_URIRESOLVER_PLUGIN_CLASS);
            this.createResolverMethod = this.pluginClass.getMethod("createResolver", new Class[0]);
        }

        public URIResolverProxy createResolver() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object result = this.createResolverMethod.invoke(null, new Object[0]);
            return new URIResolverProxy(result);
        }
    }

    private static final class URIResolverProxy {
        private final Object uriResolver;
        private final Method resolveMethod;
        private final Method resolvePhysicalLocationMethod;

        public URIResolverProxy(Object uriResolver) throws SecurityException, NoSuchMethodException {
            this.uriResolver = uriResolver;
            Class<?> resolverClass = uriResolver.getClass();
            Class[] classArray = new Class[3];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz3;
            this.resolveMethod = resolverClass.getMethod("resolve", classArray);
            Class[] classArray2 = new Class[3];
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz4;
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[1] = clazz5;
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[2] = clazz6;
            this.resolvePhysicalLocationMethod = resolverClass.getMethod("resolvePhysicalLocation", classArray2);
        }

        private String invokeResolveMethod(Method method, String baseLocation, String publicId, String systemId) {
            try {
                Object result = method.invoke(this.uriResolver, baseLocation, publicId, systemId);
                return (String)result;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            return null;
        }

        public String resolve(String baseLocation, String publicId, String systemId) {
            return this.invokeResolveMethod(this.resolveMethod, baseLocation, publicId, systemId);
        }

        public String resolvePhysicalLocation(String baseLocation, String publicId, String systemId) {
            return this.invokeResolveMethod(this.resolvePhysicalLocationMethod, baseLocation, publicId, systemId);
        }
    }

    private static final class WSTEntityResolver
    extends DefaultEntityResolver
    implements EntityResolver {
        private final String baseLocation;
        private final URIResolverProxy uriResolver;

        public WSTEntityResolver(String baseLocation, URIResolverProxy uriResolver) {
            this.baseLocation = baseLocation;
            this.uriResolver = uriResolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String resolvedURI = this.uriResolver.resolve(this.baseLocation, publicId, systemId);
            return super.resolveEntity(publicId, resolvedURI);
        }
    }
}

