/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.xpath.AnnotationManagerImpl;
import org.eclipse.jet.internal.xpath.functions.StringFunction;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.xpath.DefaultXPathFunctionResolver;
import org.eclipse.jet.xpath.IAnnotationManager;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPath;
import org.eclipse.jet.xpath.XPathException;
import org.eclipse.jet.xpath.XPathExpression;
import org.eclipse.jet.xpath.XPathFactory;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jet.xpath.XPathRuntimeException;
import org.eclipse.jet.xpath.XPathUtil;
import org.eclipse.jet.xpath.XPathVariableResolver;
import org.eclipse.jet.xpath.inspector.AddElementException;
import org.eclipse.jet.xpath.inspector.CopyElementException;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;
import org.eclipse.jet.xpath.inspector.InvalidChildException;
import org.eclipse.jet.xpath.inspector.SimpleElementRequiresValueException;

public final class XPathContextExtender
implements XPathVariableResolver {
    private static String PRIVATE_CONTEXT_DATA_KEY;
    private static final Pattern DYNAMIC_XPATH;
    private static boolean DEBUG;
    private final ContextData contextData;
    private final JET2Context context;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.XPathContextExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PRIVATE_CONTEXT_DATA_KEY = clazz.getName();
        DYNAMIC_XPATH = Pattern.compile("\\{(.*?)}");
        DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/xpath/compilations")) != false;
    }

    public XPathContextExtender(JET2Context context) {
        this(context, XPathContextExtender.getInstance((JET2Context)context).contextData);
    }

    private XPathContextExtender(JET2Context context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        XPath xp = XPathFactory.newInstance().newXPath(contextData.annotationManager);
        contextData.customFunctionResolver = new DefaultXPathFunctionResolver(xp.getXPathFunctionResolver());
    }

    public static XPathContextExtender getInstance(JET2Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        XPathContextExtender ex = (XPathContextExtender)context.getPrivateData(PRIVATE_CONTEXT_DATA_KEY);
        if (ex == null) {
            ex = new XPathContextExtender(context, new ContextData());
            context.addPrivateData(PRIVATE_CONTEXT_DATA_KEY, (Object)ex);
        }
        return ex;
    }

    protected Object createExtendedData(JET2Context context) {
        ContextData contextData = new ContextData();
        XPath xp = XPathFactory.newInstance().newXPath(contextData.annotationManager);
        contextData.customFunctionResolver = new DefaultXPathFunctionResolver(xp.getXPathFunctionResolver());
        return contextData;
    }

    public Object resolveVariable(String name) {
        try {
            return this.context.getVariable(name);
        }
        catch (JET2TagException jET2TagException) {
            return null;
        }
    }

    public String resolveAsString(Object xpathContextObject, String selectXPath) throws JET2TagException {
        Object resultObject = this.resolveAsObject(xpathContextObject, selectXPath);
        String result = null;
        if (resultObject instanceof NodeSet) {
            if (((NodeSet)resultObject).size() > 0) {
                result = XPathUtil.xpathString(resultObject);
            }
        } else if (resultObject != null) {
            result = XPathUtil.xpathString(resultObject);
        }
        return result;
    }

    public String resolveAsString(String selectXPath) throws JET2TagException {
        return this.resolveAsString(this.currentXPathContextObject(), selectXPath);
    }

    public Object resolveSingle(Object xpathContextObject, String selectXPath) throws JET2TagException {
        try {
            XPathExpression expr = this.compileXPath(selectXPath);
            return expr.evaluateAsSingleNode(xpathContextObject);
        }
        catch (XPathException e) {
            throw new JET2TagException((Throwable)e);
        }
    }

    public Object resolveSingle(String selectXPath) throws JET2TagException {
        return this.resolveSingle(this.currentXPathContextObject(), selectXPath);
    }

    private XPathExpression compileXPath(String selectXPath) throws XPathException {
        Object result = this.contextData.knownXPathExpressions.get(selectXPath);
        if (result == null) {
            block8: {
                if (DEBUG) {
                    System.out.println("XPath compile of " + selectXPath);
                }
                XPath xp = XPathFactory.newInstance().newXPath(this.contextData.annotationManager);
                xp.setXPathFunctionResolver(this.contextData.customFunctionResolver);
                xp.setXPathVariableResolver(this);
                try {
                    result = xp.compile(selectXPath);
                    if (DEBUG) {
                        System.out.println("  compiled to " + result);
                    }
                }
                catch (XPathException e) {
                    result = e;
                    if (!DEBUG) break block8;
                    System.out.println("  exception " + result);
                }
            }
            this.contextData.knownXPathExpressions.put(selectXPath, result);
        } else if (DEBUG) {
            System.out.println("XPath cache hit on " + selectXPath);
        }
        if (result instanceof XPathExpression) {
            return (XPathExpression)result;
        }
        throw (XPathException)result;
    }

    public Object currentXPathContextObject() {
        return this.contextData.contextObjectStack.isEmpty() ? this.context.getSource() : this.contextData.contextObjectStack.peek();
    }

    public void pushXPathContextObject(Object contextObject) {
        this.contextData.contextObjectStack.push(contextObject);
    }

    public Object popXPathContextObject() {
        return this.contextData.contextObjectStack.pop();
    }

    public Object[] resolve(Object xpathContextObject, String selectXPath) throws JET2TagException {
        try {
            XPathExpression expr = this.compileXPath(selectXPath);
            return expr.evaluateAsNodeSet(xpathContextObject).toArray();
        }
        catch (XPathException e) {
            throw new JET2TagException((Throwable)e);
        }
    }

    public Object[] resolve(String selectXPath) throws JET2TagException {
        return this.resolve(this.currentXPathContextObject(), selectXPath);
    }

    public boolean resolveTest(Object xpathContext, String testXPath) throws JET2TagException {
        try {
            XPathExpression expr = this.compileXPath(testXPath);
            return expr.evaluateAsBoolean(xpathContext);
        }
        catch (XPathException e) {
            throw new JET2TagException((Throwable)e);
        }
    }

    public boolean resolveTest(String textXPath) throws JET2TagException {
        return this.resolveTest(this.currentXPathContextObject(), textXPath);
    }

    public boolean setAttribute(Object element, String name, String bodyContent) throws JET2TagException {
        IElementInspector elementInspector = this.getElementInspector(element);
        boolean isSet = false;
        try {
            isSet = elementInspector.createAttribute(element, name, bodyContent);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        if (!isSet && this.contextData.annotationManager != null) {
            Object annotation = this.contextData.annotationManager.getAnnotationObject(element);
            elementInspector = this.getElementInspector(annotation);
            isSet = elementInspector.createAttribute(annotation, name, bodyContent);
        }
        return isSet;
    }

    public String resolveDynamic(String value) throws JET2TagException {
        Matcher matcher = DYNAMIC_XPATH.matcher(value);
        return matcher.find() ? this.internalResolveDynamic(value, matcher) : value;
    }

    public static String resolveDynamic(String value, JET2Context context) throws JET2TagException {
        Matcher matcher = DYNAMIC_XPATH.matcher(value);
        if (matcher.find()) {
            return XPathContextExtender.getInstance(context).internalResolveDynamic(value, matcher);
        }
        return value;
    }

    private String internalResolveDynamic(String value, Matcher matcher) {
        Object contextObject = this.currentXPathContextObject();
        StringBuffer buffer = new StringBuffer(value);
        int fudgeFactor = 0;
        do {
            String xpath;
            String resolved;
            if ((resolved = this.resolveAsString(contextObject, xpath = matcher.group(1))) == null) {
                String msg = JET2Messages.XPath_DynamicExpressionIsNull;
                throw new JET2TagException(MessageFormat.format(msg, xpath));
            }
            int mStart = matcher.start();
            int mEnd = matcher.end();
            buffer.replace(fudgeFactor + mStart, fudgeFactor + mEnd, resolved);
            int mLen = mEnd - mStart;
            fudgeFactor += resolved.length() - mLen;
        } while (matcher.find());
        return buffer.toString();
    }

    private IElementInspector getElementInspector(Object element) throws JET2TagException {
        INodeInspector inspector = InspectorManager.getInstance().getInspector(element);
        if (inspector == null || inspector.getNodeKind(element) != INodeInspector.NodeKind.ELEMENT || !(inspector instanceof IElementInspector)) {
            throw new JET2TagException(JET2Messages.XPath_NotAnElement);
        }
        return (IElementInspector)inspector;
    }

    public Object addElement(Object parent, String name) throws JET2TagException {
        IElementInspector inspector = this.getElementInspector(parent);
        try {
            return inspector.addElement(parent, new ExpandedName(name), null);
        }
        catch (SimpleElementRequiresValueException simpleElementRequiresValueException) {
            throw new JET2TagException(JET2Messages.XPath_UseAddTextElement);
        }
        catch (InvalidChildException e) {
            throw new JET2TagException((Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw this.convertToTagException(e);
        }
    }

    public void removeElement(Object element) throws JET2TagException {
        IElementInspector inspector = this.getElementInspector(element);
        try {
            inspector.removeElement(element);
        }
        catch (UnsupportedOperationException e) {
            throw this.convertToTagException(e);
        }
    }

    private JET2TagException convertToTagException(UnsupportedOperationException e) {
        return new JET2TagException(e.toString());
    }

    public Object copyElement(Object srcElement, Object tgtParent, String name, boolean recursive) throws JET2TagException {
        IElementInspector inspector = this.getElementInspector(tgtParent);
        try {
            return inspector.copyElement(tgtParent, srcElement, name, recursive);
        }
        catch (CopyElementException e) {
            throw new JET2TagException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw this.convertToTagException(e);
        }
    }

    public Object addTextElement(Object parentElement, String name, String bodyContent) throws JET2TagException {
        return this.addTextElement(parentElement, name, bodyContent, false);
    }

    public Object addTextElement(Object parentElement, String name, String bodyContent, boolean asCData) throws JET2TagException {
        IElementInspector inspector = this.getElementInspector(parentElement);
        try {
            return inspector.addTextElement(parentElement, name, bodyContent, asCData);
        }
        catch (AddElementException e) {
            throw new JET2TagException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw this.convertToTagException(e);
        }
    }

    public Object resolveAsObject(Object contextObject, String selectXPath) throws JET2TagException {
        try {
            XPathExpression expr = this.compileXPath(selectXPath);
            return expr.evaluate(contextObject);
        }
        catch (XPathException e) {
            throw new JET2TagException(e.getMessage(), (Throwable)e);
        }
        catch (XPathRuntimeException e) {
            throw new JET2TagException(e.getMessage(), (Throwable)e);
        }
    }

    public Object resolveAsObject(String selectXPath) throws JET2TagException {
        return this.resolveAsObject(this.currentXPathContextObject(), selectXPath);
    }

    public Object getAttributeValue(Object element, String attributeName) throws JET2TagException {
        IElementInspector inspector = this.getElementInspector(element);
        Object namedAttribute = inspector.getNamedAttribute(element, new ExpandedName(attributeName));
        INodeInspector attrInspector = InspectorManager.getInstance().getInspector(namedAttribute);
        if (attrInspector != null) {
            return attrInspector.stringValueOf(namedAttribute);
        }
        throw new JET2TagException(MessageFormat.format(JET2Messages.XPath_NoValueForAttribute, attributeName));
    }

    public void removeAttribute(Object element, String attributeName) throws JET2TagException {
        IElementInspector inspector = this.getElementInspector(element);
        try {
            inspector.removeAttribute(element, attributeName);
        }
        catch (UnsupportedOperationException e) {
            throw this.convertToTagException(e);
        }
    }

    public String getContent(Object object) throws JET2TagException {
        return StringFunction.evaluate(object);
    }

    public void addCustomFunctions(XPathFunctionMetaData[] functionData) {
        DefaultXPathFunctionResolver resolver = this.contextData.customFunctionResolver;
        int i = 0;
        while (i < functionData.length) {
            resolver.addFunction(functionData[i]);
            ++i;
        }
    }

    private static final class ContextData {
        public final IAnnotationManager annotationManager = new AnnotationManagerImpl();
        public DefaultXPathFunctionResolver customFunctionResolver = null;
        public final Map knownXPathExpressions = new HashMap();
        public final Stack contextObjectStack = new Stack();

        private ContextData() {
        }
    }
}

