/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Point2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.StartVisiblePredicate;

public class CollapsedSubtreeLayout
extends Layout {
    private int m_orientation;
    private Point2D m_point = new Point2D.Double();

    public CollapsedSubtreeLayout(String group) {
        this(group, 4);
    }

    public CollapsedSubtreeLayout(String group, int orientation) {
        super(group);
        this.m_orientation = orientation;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation < 0 || orientation >= 5) {
            throw new IllegalArgumentException("Unrecognized orientation value: " + orientation);
        }
        this.m_orientation = orientation;
    }

    public void run(double frac) {
        Point2D p;
        NodeItem n;
        VisualItem item;
        Iterator items = this.m_vis.visibleItems(this.m_group);
        while (items.hasNext()) {
            item = (VisualItem)items.next();
            if (!(item instanceof NodeItem) || item.isStartVisible()) continue;
            n = (NodeItem)item;
            p = this.getPoint(n, true);
            n.setStartX(p.getX());
            n.setStartY(p.getY());
        }
        items = this.m_vis.items(this.m_group, StartVisiblePredicate.TRUE);
        while (items.hasNext()) {
            item = (VisualItem)items.next();
            if (!(item instanceof NodeItem) || item.isEndVisible()) continue;
            n = (NodeItem)item;
            p = this.getPoint(n, false);
            n.setStartX(n.getEndX());
            n.setStartY(n.getEndY());
            n.setEndX(p.getX());
            n.setEndY(p.getY());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Point2D getPoint(NodeItem n, boolean start) {
        block10: {
            p = (NodeItem)n.getParent();
            if (!start) ** GOTO lbl8
            while (p != null && !p.isStartVisible()) {
                p = (NodeItem)p.getParent();
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                p = (NodeItem)p.getParent();
lbl8:
                // 2 sources

                ** while (p != null && !p.isEndVisible())
            }
        }
        if (p == null) {
            this.m_point.setLocation(n.getX(), n.getY());
            return this.m_point;
        }
        x = start != false ? p.getStartX() : p.getEndX();
        y = start != false ? p.getStartY() : p.getEndY();
        b = p.getBounds();
        switch (this.m_orientation) {
            case 0: {
                this.m_point.setLocation(x + b.getWidth(), y);
                break;
            }
            case 1: {
                this.m_point.setLocation(x - b.getWidth(), y);
                break;
            }
            case 2: {
                this.m_point.setLocation(x, y + b.getHeight());
                break;
            }
            case 3: {
                this.m_point.setLocation(x, y - b.getHeight());
                break;
            }
            case 4: {
                this.m_point.setLocation(x, y);
            }
        }
        return this.m_point;
    }
}

