/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.visual.VisualItem;

public class ShapeAction
extends EncoderAction {
    protected int m_defaultShape = 0;

    public ShapeAction() {
    }

    public ShapeAction(String group) {
        super(group);
    }

    public ShapeAction(String group, int shape) {
        super(group);
        this.m_defaultShape = shape;
    }

    public int getDefaultSize() {
        return this.m_defaultShape;
    }

    public void setDefaultShape(int defaultShape) {
        this.m_defaultShape = defaultShape;
    }

    public void add(Predicate p, int shape) {
        super.add(p, new Integer(shape));
    }

    public void add(String expr, int shape) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        this.add(p, shape);
    }

    public void add(Predicate p, ShapeAction f) {
        super.add(p, f);
    }

    public void add(String expr, ShapeAction f) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        super.add(p, f);
    }

    public void process(VisualItem item, double frac) {
        item.setShape(this.getShape(item));
    }

    public int getShape(VisualItem item) {
        Object o = this.lookup(item);
        if (o != null) {
            if (o instanceof ShapeAction) {
                return ((ShapeAction)o).getShape(item);
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.m_defaultShape;
    }
}

