/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/ 
 * 
 *  SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrus.sysml14.validation.rules.allocations;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.sysml14.allocations.Allocate;
import org.eclipse.uml2.uml.Abstraction;

/**
 * 15.3.2.1 Allocate[2] A single «allocate» dependency shall have only one client
 * (from) and one supplier (to).
 */
public class AllocateOneClientSupplierModelConstraint extends AbstractModelConstraint {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.emf.validation.AbstractModelConstraint#validate(org.eclipse.
	 * emf.validation.IValidationContext)
	 */
	@Override
	public IStatus validate(IValidationContext context) {
		Allocate allocate = (Allocate) context.getTarget();

		Abstraction abstraction = allocate.getBase_Abstraction();
		if (abstraction != null){ // 15.3.2.1 Allocate[1] will fail
			if (abstraction.getClients().size() != 1 || abstraction.getSuppliers().size() != 1) {
				return context.createFailureStatus(context.getTarget());
			}			
		}
		return context.createSuccessStatus();
	}

}
