/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import org.eclipse.emf.cdo.CDODeltaNotification;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;

public class CDODeltaNotificationImpl
extends ENotificationImpl
implements CDODeltaNotification {
    private CDORevisionDelta revisionDelta;

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, Object oldValue, Object newValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature, oldValue, newValue);
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, Object oldValue, Object newValue, int position) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature, oldValue, newValue, position);
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, boolean oldBooleanValue, boolean newBooleanValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldBooleanValue, newBooleanValue);
        this.feature = feature;
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, byte oldByteValue, byte newByteValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldByteValue, newByteValue);
        this.feature = feature;
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, char oldCharValue, char newCharValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldCharValue, newCharValue);
        this.feature = feature;
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, double oldDoubleValue, double newDoubleValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldDoubleValue, newDoubleValue);
        this.feature = feature;
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, float oldFloatValue, float newFloatValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldFloatValue, newFloatValue);
        this.feature = feature;
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, int oldIntValue, int newIntValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldIntValue, newIntValue);
        this.feature = feature;
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, long oldLongValue, long newLongValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldLongValue, newLongValue);
        this.feature = feature;
    }

    public CDODeltaNotificationImpl(InternalEObject notifier, int eventType, EStructuralFeature feature, short oldShortValue, short newShortValue) {
        super(CDODeltaNotificationImpl.getEObject(notifier), eventType, feature.getFeatureID(), oldShortValue, newShortValue);
        this.feature = feature;
    }

    public Object getNewValue() {
        Object object = super.getNewValue();
        return this.adapt(object);
    }

    public Object getOldValue() {
        EStructuralFeature structuralFeature;
        Object feature;
        Object oldValue = super.getOldValue();
        if (oldValue == null && this.getEventType() == 6 && (feature = this.getFeature()) instanceof EStructuralFeature && (structuralFeature = (EStructuralFeature)feature).isMany()) {
            return ECollections.emptyEList();
        }
        return this.adapt(oldValue);
    }

    public Object adapt(Object object) {
        if (object instanceof CDOID) {
            CDOID id = (CDOID)object;
            if (id instanceof CDOIDExternal) {
                CDOIDExternal idExternal = (CDOIDExternal)id;
                Resource resource = this.notifier.eResource();
                if (resource != null) {
                    String uriString = idExternal.getURI();
                    URI uri = URI.createURI((String)uriString);
                    object = resource.getResourceSet().getEObject(uri, false);
                }
            } else {
                try {
                    InternalCDOView view = this.getCDOObject().cdoView();
                    object = view.getObject(id, true);
                }
                catch (ObjectNotFoundException ex) {
                    object = null;
                }
            }
        }
        if (object instanceof CDOObject) {
            object = CDOUtil.getEObject((EObject)object);
        }
        if (this.feature instanceof EAttribute) {
            if (object == null) {
                object = this.feature.getDefaultValue();
            } else {
                EDataType eAttributeType = ((EAttribute)this.feature).getEAttributeType();
                if (eAttributeType != null && eAttributeType instanceof EEnum && object instanceof Integer) {
                    EEnumLiteral literal = ((EEnum)eAttributeType).getEEnumLiteral(((Integer)object).intValue());
                    String stringValue = literal.getLiteral();
                    object = eAttributeType.getEPackage().getEFactoryInstance().createFromString(eAttributeType, stringValue);
                }
            }
        }
        return object;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public CDORevisionDelta getRevisionDelta() {
        return this.revisionDelta;
    }

    public void setRevisionDelta(CDORevisionDelta revisionDelta) {
        this.revisionDelta = revisionDelta;
    }

    public boolean merge(Notification notification) {
        return false;
    }

    private InternalCDOObject getCDOObject() {
        return (InternalCDOObject)CDOUtil.getCDOObject((EObject)this.getNotifier());
    }

    private static InternalEObject getEObject(InternalEObject notifier) {
        return (InternalEObject)CDOUtil.getEObject((EObject)notifier);
    }
}

