/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.ui;

import java.util.Set;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;

public abstract class AbstractContextChangeSetManager
extends AbstractContextListener {
    protected boolean isEnabled = false;
    private boolean isInitialized = false;
    private final ITaskListChangeListener WORKING_SET_LABEL_UPDATE_LISTENER = new TaskListChangeAdapter(){

        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                if (taskContainerDelta.getKind() == TaskContainerDelta.Kind.ROOT && !AbstractContextChangeSetManager.this.isInitialized) {
                    AbstractContextChangeSetManager.this.initContextChangeSets();
                    AbstractContextChangeSetManager.this.isInitialized = true;
                }
                if (!(taskContainerDelta.getElement() instanceof ITask)) continue;
                ITask task = (ITask)taskContainerDelta.getElement();
                switch (taskContainerDelta.getKind()) {
                    case CONTENT: {
                        AbstractContextChangeSetManager.this.updateChangeSetLabel(task);
                    }
                }
            }
        }
    };

    public void enable() {
        if (!this.isEnabled) {
            this.isEnabled = true;
            TasksUiInternal.getTaskList().addChangeListener(this.WORKING_SET_LABEL_UPDATE_LISTENER);
            if (!this.isInitialized) {
                this.initContextChangeSets();
            }
            if (ContextCore.getContextManager().isContextActive()) {
                this.contextActivated(ContextCore.getContextManager().getActiveContext());
            }
            ContextCore.getContextManager().addListener((AbstractContextListener)this);
        }
    }

    public void disable() {
        ContextCore.getContextManager().removeListener((AbstractContextListener)this);
        TasksUiInternal.getTaskList().removeChangeListener(this.WORKING_SET_LABEL_UPDATE_LISTENER);
        this.isEnabled = false;
    }

    protected abstract void initContextChangeSets();

    protected abstract void updateChangeSetLabel(ITask var1);
}

