/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

public class RepositoryTaskHandleUtil {
    public static final String HANDLE_DELIM = "-";
    private static final String MISSING_REPOSITORY = "norepository";

    public static String getHandle(String repositoryUrl, String taskId) {
        if (!RepositoryTaskHandleUtil.isValidTaskId(taskId)) {
            throw new RuntimeException("invalid handle for task, can not contain: -, was: " + taskId);
        }
        if (repositoryUrl == null) {
            return "norepository-" + taskId;
        }
        return (String.valueOf(repositoryUrl) + HANDLE_DELIM + taskId).intern();
    }

    public static String getRepositoryUrl(String taskHandle) {
        int index = taskHandle.lastIndexOf(HANDLE_DELIM);
        String url = null;
        if (index != -1) {
            url = taskHandle.substring(0, index);
        }
        return url;
    }

    public static String getTaskId(String taskHandle) {
        int index = taskHandle.lastIndexOf(HANDLE_DELIM);
        if (index != -1) {
            String id = taskHandle.substring(index + 1);
            return id;
        }
        return null;
    }

    public static boolean isValidTaskId(String taskId) {
        return !taskId.contains(HANDLE_DELIM);
    }
}

