/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.preferences;

import java.io.File;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.emf.core.internal.resources.PathmapManager;
import org.eclipse.gmf.runtime.emf.ui.internal.MslUIPlugin;
import org.eclipse.gmf.runtime.emf.ui.internal.l10n.EMFUIMessages;
import org.eclipse.gmf.runtime.emf.ui.preferences.PathmapsPreferencePage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class NewPathVariableDialog
extends TitleAreaDialog {
    private String variableName;
    private IPath variableLocation;
    private Text nameText;
    private Text locationText;
    private String initialName;
    private String initialLocation;
    private final IPathVariableManager pathMgr;
    private final String plainMsg;
    private final PathmapsPreferencePage page;

    private NewPathVariableDialog(PathmapsPreferencePage page, String name, String location) {
        super(page.getShell());
        this.page = page;
        this.initialName = name;
        this.initialLocation = location;
        this.plainMsg = name != null ? EMFUIMessages.PathVariableDialog_editMessage : EMFUIMessages.PathVariableDialog_newMessage;
        this.pathMgr = ResourcesPlugin.getWorkspace().getPathVariableManager();
    }

    public static NewPathVariableDialog openNew(PathmapsPreferencePage page) {
        NewPathVariableDialog dlg = new NewPathVariableDialog(page, null, null);
        return dlg.open() == 0 ? dlg : null;
    }

    public static NewPathVariableDialog openEdit(PathmapsPreferencePage page, String name, String location) {
        NewPathVariableDialog dlg = new NewPathVariableDialog(page, name, location);
        return dlg.open() == 0 ? dlg : null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.initialName != null) {
            newShell.setText(EMFUIMessages.PathVariableDialog_editTitle);
        } else {
            newShell.setText(EMFUIMessages.PathVariableDialog_newTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)result);
        Composite composite = new Composite(result, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData data = null;
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        data.verticalIndent = this.convertVerticalDLUsToPixels(7);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(EMFUIMessages.PathVariableDialog_nameLabel);
        data = new GridData(1);
        label.setLayoutData((Object)data);
        this.nameText = new Text(composite, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)data);
        if (this.initialName != null) {
            this.nameText.setText(this.initialName);
        }
        new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText(EMFUIMessages.PathVariableDialog_locationLabel);
        data = new GridData(1);
        label.setLayoutData((Object)data);
        this.locationText = new Text(composite, 0x2000800);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.locationText.setLayoutData((Object)data);
        if (this.initialLocation != null) {
            this.locationText.setText(this.initialLocation);
        }
        Button browseButton = new Button(composite, 8);
        browseButton.setText(EMFUIMessages.PathVariableDialog_browseButton);
        this.setButtonLayoutData(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(NewPathVariableDialog.this.getShell());
                dlg.setText(EMFUIMessages.PathVariableDialog_browseDialogTitle);
                dlg.setMessage(EMFUIMessages.PathVariableDialog_browseDialogMessage);
                String folder = dlg.open();
                if (folder != null) {
                    NewPathVariableDialog.this.locationText.setText(folder);
                }
            }
        });
        ModifyListener l = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPathVariableDialog.this.validateInputs();
            }
        };
        this.nameText.addModifyListener(l);
        this.locationText.addModifyListener(l);
        if (this.initialName != null) {
            this.setTitle(EMFUIMessages.PathVariableDialog_editTitle);
            this.locationText.setSelection(0, this.locationText.getText().length());
            this.locationText.setFocus();
        } else {
            this.setTitle(EMFUIMessages.PathVariableDialog_newTitle);
        }
        this.setMessage(this.plainMsg);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void validateInputs() {
        boolean hasLocation;
        IStatus status = Status.OK_STATUS;
        boolean isError = false;
        String name = this.nameText.getText();
        String location = this.locationText.getText();
        boolean hasName = name.length() > 0;
        boolean bl = hasLocation = location.length() > 0;
        if (hasName && !name.equals(this.initialName)) {
            status = this.validateName(name);
        }
        if (!status.isOK()) {
            isError = true;
            this.setMessage(status.getMessage(), 3);
        } else if (hasLocation && !location.equals(this.initialLocation) && !(status = this.validateLocation((IPath)new Path(location))).isOK()) {
            isError = status.getSeverity() >= 4;
            this.setMessage(status.getMessage(), isError ? 3 : 2);
        }
        if (status.isOK()) {
            this.setMessage(this.plainMsg);
        }
        if (this.initialName != null && name.equals(this.initialName) && location.equals(this.initialLocation)) {
            hasName = false;
        }
        this.getButton(0).setEnabled(!isError && hasName && hasLocation);
    }

    private IStatus validateName(String name) {
        Object result = this.pathMgr.isDefined(name) && !this.page.isRemoved(name) || PathmapManager.isRegisteredPathVariable((String)name) || this.page.isAdded(name) ? new Status(4, MslUIPlugin.getPluginId(), EMFUIMessages.PathVariableDialog_alreadyDefined_ERROR_) : (!URI.validSegment((String)name) ? new Status(4, MslUIPlugin.getPluginId(), EMFUIMessages.PathVariableDialog_invalidSegment_ERROR_) : this.pathMgr.validateName(name));
        return result;
    }

    private IStatus validateLocation(IPath location) {
        File file = location.toFile();
        Object result = file.exists() && !file.isDirectory() ? new Status(4, MslUIPlugin.getPluginId(), EMFUIMessages.PathVariableDialog_notFolder_ERROR_) : (!file.exists() ? new Status(4, MslUIPlugin.getPluginId(), EMFUIMessages.PathVariableDialog_noSuchFolder_ERROR_) : this.pathMgr.validateValue(location));
        if (result.isOK() && this.page.isLocationDefined(location)) {
            result = new Status(2, MslUIPlugin.getPluginId(), EMFUIMessages.PathVariableDialog_sameLocation_WARN_);
        }
        return result;
    }

    protected void okPressed() {
        this.variableName = this.nameText.getText();
        this.variableLocation = new Path(this.locationText.getText());
        super.okPressed();
    }

    String getVariableName() {
        return this.variableName;
    }

    IPath getVariableLocation() {
        return this.variableLocation;
    }
}

