/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent.connector;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.SshException;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.LibraryHolder;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Texts;
import org.eclipse.jgit.transport.sshd.agent.AbstractConnector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.StringUtils;

public class WinPipeConnector
extends AbstractConnector {
    private static final String CANONICAL_PIPE_NAME = "\\\\.\\pipe\\openssh-ssh-agent";
    public static final ConnectorFactory.ConnectorDescriptor DESCRIPTOR = new ConnectorFactory.ConnectorDescriptor(){

        public String getIdentityAgent() {
            return WinPipeConnector.CANONICAL_PIPE_NAME;
        }

        public String getDisplayName() {
            return Texts.get().winOpenSsh;
        }
    };
    private static final int FILE_SHARE_NONE = 0;
    private static final int FILE_ATTRIBUTE_NONE = 0;
    private final String pipeName;
    private final AtomicBoolean connected = new AtomicBoolean();
    private volatile WinNT.HANDLE fileHandle;

    public WinPipeConnector(String pipeName) {
        this.pipeName = pipeName.replace('/', '\\');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect() throws IOException {
        if (StringUtils.isEmptyOrNull((String)this.pipeName)) {
            return false;
        }
        WinNT.HANDLE file = this.fileHandle;
        WinPipeConnector winPipeConnector = this;
        synchronized (winPipeConnector) {
            if (this.connected.get()) {
                return true;
            }
            LibraryHolder libs = LibraryHolder.getLibrary();
            if (libs == null) {
                return false;
            }
            file = libs.kernel.CreateFile(this.pipeName, -1073741824, 0, null, 3, 0, null);
            if (file == null || file == WinBase.INVALID_HANDLE_VALUE) {
                int errorCode = libs.kernel.GetLastError();
                if (errorCode == 2 && CANONICAL_PIPE_NAME.equalsIgnoreCase(this.pipeName)) {
                    return false;
                }
                LastErrorException cause = new LastErrorException(libs.systemError());
                throw new IOException(MessageFormat.format(Texts.get().msgConnectPipeFailed, this.pipeName), cause);
            }
            this.connected.set(true);
        }
        this.fileHandle = file;
        return this.connected.get();
    }

    public synchronized void close() throws IOException {
        WinNT.HANDLE file = this.fileHandle;
        if (this.connected.getAndSet(false) && this.fileHandle != null) {
            this.fileHandle = null;
            LibraryHolder libs = LibraryHolder.getLibrary();
            boolean success = libs.kernel.CloseHandle(file);
            if (!success) {
                LastErrorException cause = new LastErrorException(libs.systemError());
                throw new IOException(MessageFormat.format(Texts.get().msgCloseFailed, this.pipeName), cause);
            }
        }
    }

    public byte[] rpc(byte command, byte[] message) throws IOException {
        this.prepareMessage(command, message);
        WinNT.HANDLE file = this.fileHandle;
        if (!this.connected.get() || file == null) {
            throw new IllegalStateException("Not connected to SSH agent");
        }
        LibraryHolder libs = LibraryHolder.getLibrary();
        this.writeFully(libs, file, message);
        byte[] lengthBuf = new byte[4];
        this.readFully(libs, file, lengthBuf);
        int length = this.toLength(command, lengthBuf);
        byte[] payload = new byte[length];
        this.readFully(libs, file, payload);
        return payload;
    }

    private void writeFully(LibraryHolder libs, WinNT.HANDLE file, byte[] message) throws IOException {
        byte[] buf = message;
        int toWrite = buf.length;
        try {
            while (toWrite > 0) {
                IntByReference written = new IntByReference();
                boolean success = libs.kernel.WriteFile(file, buf, buf.length, written, null);
                if (!success) {
                    throw new LastErrorException(libs.systemError());
                }
                int actuallyWritten = written.getValue();
                if (actuallyWritten <= 0 || (toWrite -= actuallyWritten) <= 0) continue;
                buf = Arrays.copyOfRange(buf, actuallyWritten, buf.length);
            }
        }
        catch (LastErrorException e) {
            throw new IOException(MessageFormat.format(Texts.get().msgSendFailed, Integer.toString(message.length), Integer.toString(toWrite)), e);
        }
    }

    private void readFully(LibraryHolder libs, WinNT.HANDLE file, byte[] data) throws IOException {
        int n = 0;
        int offset = 0;
        while (offset < data.length && (n = this.read(libs, file, data, offset, data.length - offset)) > 0) {
            offset += n;
        }
        if (offset < data.length) {
            throw new SshException(MessageFormat.format(Texts.get().msgShortRead, Integer.toString(data.length), Integer.toString(offset), Integer.toString(n)));
        }
    }

    private int read(LibraryHolder libs, WinNT.HANDLE file, byte[] buffer, int offset, int length) throws IOException {
        try {
            int toRead = length;
            IntByReference read = new IntByReference();
            if (offset == 0) {
                boolean success = libs.kernel.ReadFile(file, buffer, toRead, read, null);
                if (!success) {
                    throw new LastErrorException(libs.systemError());
                }
                return read.getValue();
            }
            byte[] data = new byte[length];
            boolean success = libs.kernel.ReadFile(file, buffer, toRead, read, null);
            if (!success) {
                throw new LastErrorException(libs.systemError());
            }
            int actuallyRead = read.getValue();
            if (actuallyRead > 0) {
                System.arraycopy(data, 0, buffer, offset, actuallyRead);
            }
            return actuallyRead;
        }
        catch (LastErrorException e) {
            throw new IOException(MessageFormat.format(Texts.get().msgReadFailed, Integer.toString(length)), e);
        }
    }
}

