/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionRequest;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.OMPlatform;

public final class UserInfo {
    private static final String UNKNOWN = "Unknown";
    private String firstName;
    private String lastName;
    private String displayName;

    UserInfo() {
        this(null, null, null);
    }

    public UserInfo(String firstName, String lastName, String displayName) {
        this.change(firstName, lastName, displayName);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "UserInfo[" + this.displayName + "]";
    }

    void change(String firstName, String lastName, String displayName) {
        this.firstName = StringUtil.isEmpty((String)firstName) ? UNKNOWN : firstName;
        this.lastName = StringUtil.isEmpty((String)lastName) ? UNKNOWN : lastName;
        this.displayName = StringUtil.isEmpty((String)displayName) ? UNKNOWN : displayName;
    }

    void change(UserInfo userInfo) {
        this.change(userInfo.getFirstName(), userInfo.getLastName(), userInfo.getDisplayName());
    }

    byte[] serialize() {
        String string = String.valueOf(this.firstName) + StringUtil.NL + this.lastName + StringUtil.NL + this.displayName;
        return string.getBytes(StandardCharsets.UTF_8);
    }

    void deserialize(byte[] data) {
        String string = new String(data, StandardCharsets.UTF_8);
        StringTokenizer tokenizer = new StringTokenizer(string, StringUtil.NL);
        this.change(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
    }

    public static final class Manager
    extends Lifecycle {
        public static final Manager INSTANCE = new Manager();
        private final Map<CDORemoteSession, UserInfo> remoteUsers = new HashMap<CDORemoteSession, UserInfo>();
        private UserInfoStorage localUserInfoStorage;
        private UserInfo localUser;
        private CDORemoteSessionRequest.GlobalRequestHandler userInfoRequestHandler;
        private CDORemoteSessionRequest.GlobalRequestHandler userInfoNotificationHandler;

        private Manager() {
        }

        public synchronized UserInfo getLocalUser() {
            return this.localUser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeLocalUser(String firstName, String lastName, String displayName) {
            CDORemoteSession[] remoteSessions;
            UserInfo userInfo;
            Manager manager = this;
            synchronized (manager) {
                if (this.localUser != null) {
                    this.localUser.change(firstName, lastName, displayName);
                }
                userInfo = this.localUser;
                remoteSessions = this.remoteUsers.keySet().toArray(new CDORemoteSession[this.remoteUsers.size()]);
            }
            if (userInfo != null) {
                if (this.localUserInfoStorage instanceof UserInfoStorage.Writable) {
                    UserInfoStorage.Writable writable = (UserInfoStorage.Writable)this.localUserInfoStorage;
                    try {
                        writable.saveUserInfo(userInfo);
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
                this.fireEvent((IEvent)new UserChangedEvent(null, userInfo));
                byte[] data = userInfo.serialize();
                CDORemoteSession[] cDORemoteSessionArray = remoteSessions;
                int n = remoteSessions.length;
                int n2 = 0;
                while (n2 < n) {
                    CDORemoteSession remoteSession = cDORemoteSessionArray[n2];
                    new CDORemoteSessionRequest("org.eclipse.emf.cdo.ui.UserInfoChanged", data).send(remoteSession);
                    ++n2;
                }
            }
        }

        public synchronized UserInfo getRemoteUser(CDORemoteSession remoteSession) {
            return this.remoteUsers.computeIfAbsent(remoteSession, k -> {
                UserInfo userInfo = new UserInfo();
                new CDORemoteSessionRequest("org.eclipse.emf.cdo.ui.UserInfo").onResponse(data -> this.changeRemoteUser(remoteSession, (byte[])data)).send(remoteSession);
                return userInfo;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void changeRemoteUser(CDORemoteSession remoteSession, byte[] data) {
            UserInfo userInfo;
            Manager manager = this;
            synchronized (manager) {
                userInfo = this.remoteUsers.get(remoteSession);
                if (userInfo != null) {
                    userInfo.deserialize(data);
                }
            }
            if (userInfo != null) {
                this.fireEvent((IEvent)new UserChangedEvent(remoteSession, userInfo));
            }
        }

        protected void doActivate() throws Exception {
            super.doActivate();
            this.localUserInfoStorage = UserInfoStorage.Factory.get((IManagedContainer)IPluginContainer.INSTANCE);
            UserInfo userInfo = this.localUser = this.localUserInfoStorage == null ? null : this.localUserInfoStorage.loadUserInfo();
            if (this.localUser == null) {
                this.localUser = new UserInfo();
            }
            this.userInfoRequestHandler = new UserInfoRequestHandler();
            this.userInfoNotificationHandler = new UserInfoNotificationHandler();
        }

        protected void doDeactivate() throws Exception {
            this.userInfoNotificationHandler.deactivate();
            this.userInfoNotificationHandler = null;
            this.userInfoRequestHandler.deactivate();
            this.userInfoRequestHandler = null;
            this.localUser = null;
            super.doDeactivate();
        }

        public static final class HomeUserInfoStorage
        implements UserInfoStorage.Writable {
            private static final String PROP_FIRST_NAME = "firstName";
            private static final String PROP_LAST_NAME = "lastName";
            private static final String PROP_DISPLAY_NAME = "displayName";
            private static final File FILE = new File(OM.BUNDLE.getUserLocation(), "user.properties");

            public HomeUserInfoStorage() {
                FILE.getParentFile().mkdirs();
            }

            @Override
            public UserInfo loadUserInfo() throws IOException {
                if (FILE.isFile()) {
                    UserInfo userInfo;
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(FILE);
                        Properties properties = new Properties();
                        properties.load(in);
                        String firstName = properties.getProperty(PROP_FIRST_NAME);
                        String lastName = properties.getProperty(PROP_LAST_NAME);
                        String displayName = properties.getProperty(PROP_DISPLAY_NAME);
                        userInfo = new UserInfo(firstName, lastName, displayName);
                    }
                    catch (Exception ex) {
                        try {
                            OM.LOG.error((Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(in);
                            throw throwable;
                        }
                        IOUtil.close((Closeable)in);
                    }
                    IOUtil.close((Closeable)in);
                    return userInfo;
                }
                return null;
            }

            @Override
            public void saveUserInfo(UserInfo userInfo) throws IOException {
                block5: {
                    FileOutputStream out = null;
                    try {
                        try {
                            out = new FileOutputStream(FILE);
                            Properties properties = new Properties();
                            properties.setProperty(PROP_FIRST_NAME, userInfo.getFirstName());
                            properties.setProperty(PROP_LAST_NAME, userInfo.getLastName());
                            properties.setProperty(PROP_DISPLAY_NAME, userInfo.getDisplayName());
                            properties.store(out, "Local user information");
                        }
                        catch (IOException ex) {
                            OM.LOG.error((Throwable)ex);
                            IOUtil.close((Closeable)out);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)out);
                }
            }

            public static void saveProperties(File folder, String fileName, Properties properties, String comment) {
                block5: {
                    FileOutputStream out = null;
                    try {
                        try {
                            folder.mkdirs();
                            File file = new File(folder, fileName);
                            out = new FileOutputStream(file);
                            properties.store(out, comment);
                        }
                        catch (IOException ex) {
                            OM.LOG.error((Throwable)ex);
                            IOUtil.close(out);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)out);
                }
            }

            public static final class Factory
            extends UserInfoStorage.Factory {
                public static final String TYPE = "home";

                public Factory() {
                    super(TYPE);
                }

                @Override
                public UserInfoStorage create(String description) throws ProductCreationException {
                    return new HomeUserInfoStorage();
                }
            }
        }

        public static final class PreferencesUserInfoStorage
        implements UserInfoStorage.Writable {
            @Override
            public UserInfo loadUserInfo() throws IOException {
                String firstName = (String)OM.PREF_USER_FIRST_NAME.getValue();
                String lastName = (String)OM.PREF_USER_LAST_NAME.getValue();
                String displayName = (String)OM.PREF_USER_DISPLAY_NAME.getValue();
                return new UserInfo(firstName, lastName, displayName);
            }

            @Override
            public void saveUserInfo(UserInfo userInfo) throws IOException {
                OM.PREF_USER_FIRST_NAME.setValue((Object)userInfo.getFirstName());
                OM.PREF_USER_LAST_NAME.setValue((Object)userInfo.getLastName());
                OM.PREF_USER_DISPLAY_NAME.setValue((Object)userInfo.getDisplayName());
            }

            public static final class Factory
            extends UserInfoStorage.Factory {
                public static final String TYPE = "preferences";

                public Factory() {
                    super(TYPE);
                }

                @Override
                public UserInfoStorage create(String description) throws ProductCreationException {
                    return new PreferencesUserInfoStorage();
                }
            }
        }

        public final class UserChangedEvent
        extends Event {
            private static final long serialVersionUID = 1L;
            private final CDORemoteSession remoteSession;
            private final UserInfo userInfo;

            protected UserChangedEvent(CDORemoteSession remoteSession, UserInfo userInfo) {
                super((INotifier)Manager.this);
                this.remoteSession = remoteSession;
                this.userInfo = userInfo;
            }

            public Manager getSource() {
                return (Manager)super.getSource();
            }

            public CDORemoteSession getRemoteSession() {
                return this.remoteSession;
            }

            public UserInfo getUserInfo() {
                return this.userInfo;
            }
        }

        private static final class UserInfoNotificationHandler
        extends CDORemoteSessionRequest.GlobalRequestHandler {
            private static final String TYPE = "org.eclipse.emf.cdo.ui.UserInfoChanged";

            public UserInfoNotificationHandler() {
                super(TYPE);
            }

            protected byte[] createResponse(CDORemoteSession sender, byte[] request) {
                INSTANCE.changeRemoteUser(sender, request);
                return null;
            }
        }

        private static final class UserInfoRequestHandler
        extends CDORemoteSessionRequest.GlobalRequestHandler {
            private static final String TYPE = "org.eclipse.emf.cdo.ui.UserInfo";

            public UserInfoRequestHandler() {
                super(TYPE);
            }

            protected byte[] createResponse(CDORemoteSession sender, byte[] request) {
                UserInfo userInfo = INSTANCE.getLocalUser();
                return userInfo.serialize();
            }
        }

        public static interface UserInfoStorage {
            public UserInfo loadUserInfo() throws IOException;

            public static abstract class Factory
            extends org.eclipse.net4j.util.factory.Factory {
                public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.ui.userInfoStorages";
                private static final String DEFAULT_TYPE = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.ui.UserInfoStorageFactory.DEFAULT_TYPE", "preferences");
                private static final String DEFAULT_DESCRIPTION = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.ui.UserInfoStorageFactory.DEFAULT_DESCRIPTION");

                public Factory(String type) {
                    super(PRODUCT_GROUP, type);
                }

                public abstract UserInfoStorage create(String var1) throws ProductCreationException;

                public static UserInfoStorage get(IManagedContainer container) {
                    return Factory.get(container, null);
                }

                public static UserInfoStorage get(IManagedContainer container, String type) {
                    return Factory.get(container, type, null);
                }

                public static UserInfoStorage get(IManagedContainer container, String type, String description) {
                    if (type == null) {
                        type = DEFAULT_TYPE;
                    }
                    if (description == null) {
                        description = DEFAULT_DESCRIPTION;
                    }
                    return (UserInfoStorage)container.getElementOrNull(PRODUCT_GROUP, type, description);
                }
            }

            public static interface Writable
            extends UserInfoStorage {
                public void saveUserInfo(UserInfo var1) throws IOException;
            }
        }
    }
}

