/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class JobListener {
    private final Set<Job> jobs = Collections.synchronizedSet(new HashSet());
    private final Runnable allJobsDone;
    private boolean started;
    private boolean complete;

    public JobListener(Runnable allJobsDone) {
        this.allJobsDone = allJobsDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Set<Job> set = this.jobs;
        synchronized (set) {
            this.started = true;
            if (this.jobs.isEmpty()) {
                this.allJobsDone.run();
                this.complete = true;
            }
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void add(final Job job, final Runnable jobDone) {
        this.jobs.add(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                jobDone.run();
                Set set = JobListener.this.jobs;
                synchronized (set) {
                    JobListener.this.jobs.remove(job);
                    if (JobListener.this.jobs.isEmpty() && JobListener.this.started) {
                        JobListener.this.allJobsDone.run();
                        JobListener.this.complete = true;
                    }
                }
            }
        });
    }
}

