/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.repository.RepositoriesView;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class RepositoriesViewCommandHandler<T extends RepositoryTreeNode<?>>
extends AbstractHandler {
    private IEvaluationContext evaluationContext;

    RepositoriesViewCommandHandler() {
    }

    public RepositoriesView getView(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        return (RepositoriesView)part;
    }

    public Shell getShell(ExecutionEvent event) {
        return HandlerUtil.getActiveShell((ExecutionEvent)event);
    }

    public void setEnabled(Object evaluationContext) {
        this.evaluationContext = evaluationContext instanceof IEvaluationContext ? (IEvaluationContext)evaluationContext : null;
    }

    public RepositoryGroup getSelectedRepositoryGroup(ExecutionEvent event) throws ExecutionException {
        Object singleSelection = null;
        if (HandlerUtil.getActivePartChecked((ExecutionEvent)event) instanceof RepositoriesView) {
            List<T> selected = this.getSelectedNodes(event);
            if (selected.size() == 1) {
                singleSelection = selected.get(0);
            }
        } else {
            ITreeSelection selection;
            RepositoriesView view = this.getRepositoriesView();
            if (view != null && (selection = view.getCommonViewer().getStructuredSelection()) != null && selection.size() == 1) {
                singleSelection = selection.getFirstElement();
            }
        }
        if (!(singleSelection instanceof RepositoryGroupNode)) {
            return null;
        }
        return (RepositoryGroup)((RepositoryGroupNode)singleSelection).getObject();
    }

    protected void expandRepositoryGroup(ExecutionEvent event, RepositoryGroup group) throws ExecutionException {
        if (group != null) {
            RepositoriesView view = null;
            IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
            view = part instanceof RepositoriesView ? (RepositoriesView)part : this.getRepositoriesView();
            if (view != null) {
                view.expandNodeForGroup(group);
            }
        }
    }

    private RepositoriesView getRepositoriesView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference ref = page.findViewReference("org.eclipse.egit.ui.RepositoriesView");
        return ref == null ? null : (RepositoriesView)ref.getView(false);
    }

    public List<T> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    protected List<T> getSelectedNodes() {
        if (this.evaluationContext != null) {
            Object selection = this.evaluationContext.getVariable("activeMenuSelection");
            if (selection == null || !(selection instanceof IStructuredSelection)) {
                selection = this.evaluationContext.getVariable("selection");
            }
            if (selection instanceof IStructuredSelection) {
                return ((IStructuredSelection)selection).toList();
            }
        }
        return Collections.emptyList();
    }

    public Shell getActiveShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    private boolean repositoryHasHead(T treeNode) {
        return SelectionRepositoryStateCache.INSTANCE.getHead(((RepositoryTreeNode)treeNode).getRepository()) != null;
    }

    private boolean selectionHasHead(boolean all) {
        List<T> selectedNodes = this.getSelectedNodes();
        if (selectedNodes.size() > 0) {
            if (all) {
                for (RepositoryTreeNode element : selectedNodes) {
                    if (this.repositoryHasHead(element)) continue;
                    return false;
                }
                return true;
            }
            return this.repositoryHasHead((RepositoryTreeNode)selectedNodes.get(0));
        }
        return false;
    }

    protected boolean selectedRepositoryHasHead() {
        return this.selectionHasHead(false);
    }

    protected boolean selectedRepositoriesHaveHead() {
        return this.selectionHasHead(true);
    }

    protected boolean isWorkingDirSelection() {
        List<T> selectedNodes = this.getSelectedNodes();
        if (selectedNodes.isEmpty()) {
            return false;
        }
        Repository repository = null;
        for (RepositoryTreeNode selectedNode : selectedNodes) {
            File file;
            Repository nodeRepository = selectedNode.getRepository();
            if (repository == null) {
                repository = nodeRepository;
            } else if (repository != nodeRepository) {
                return false;
            }
            if (selectedNode instanceof WorkingDirNode) continue;
            if (selectedNode instanceof FolderNode) {
                file = ((File)((FolderNode)selectedNode).getObject()).getAbsoluteFile();
            } else if (selectedNode instanceof FileNode) {
                file = ((File)((FileNode)selectedNode).getObject()).getAbsoluteFile();
            } else {
                return false;
            }
            File gitDir = repository.getDirectory().getAbsoluteFile();
            if (!file.toPath().startsWith(gitDir.toPath())) continue;
            return false;
        }
        return true;
    }

    protected Collection<IPath> getSelectedFileAndFolderPaths(ExecutionEvent event) throws ExecutionException {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (T selectedNode : this.getSelectedNodes(event)) {
            RepositoryTreeNode treeNode = (RepositoryTreeNode)selectedNode;
            IPath path = treeNode.getPath();
            paths.add(path);
        }
        return paths;
    }

    static <T> T getFirstOrNull(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

