/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource.parser.xml;

import java.util.HashSet;
import java.util.Stack;
import org.eclipse.eodm.rdf.resource.parser.xml.Element;
import org.eclipse.eodm.rdf.resource.parser.xml.NodeElement;
import org.eclipse.eodm.rdf.resource.parser.xml.RDFXMLParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RDFXMLContentHandler
implements ContentHandler {
    private RDFXMLParserImpl rdfParser;
    private final Stack stateStack;
    private StringBuffer charBuffer;
    private HashSet literalNamespaces = new HashSet();
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_RDF = 1;
    public static final int STATE_NODE_ELEMENT = 2;
    public static final int STATE_PROPERTY_ELEMENT = 3;
    public static final int STATE_TEXT = 4;
    private static final Integer[] INTEGER_STATES = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};

    public RDFXMLContentHandler(RDFXMLParserImpl container) {
        this.rdfParser = container;
        this.stateStack = new Stack();
        this.charBuffer = new StringBuffer();
    }

    public void endDocument() throws SAXException {
        if (this.stateStack.size() != 1) {
            this.rdfParser.error("stateStack not empty");
        }
        if (this.rdfParser.popElement() != null) {
            this.rdfParser.error("_Element stack not empty");
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.rdfParser.addNamespace(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.rdfParser.removeNamespace(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String _xmlBase;
        int currentState = this.getTopState();
        if (currentState == 0) {
            if (localName.equals("RDF") && namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                this.pushState(1);
                currentState = 1;
            } else {
                this.pushState(2);
                currentState = 2;
            }
        }
        if ((_xmlBase = atts.getValue("xml:base")) != null) {
            this.rdfParser.pushXmlBase(_xmlBase);
        } else {
            this.rdfParser.xmlBaseURI.push(this.rdfParser.xmlBaseURI.peek());
        }
        switch (currentState) {
            case 1: {
                this.pushState(2);
                break;
            }
            case 2: {
                this.rdfParser.addNodeElement(namespaceURI, localName, atts);
                this.pushState(3);
                break;
            }
            case 3: {
                this.rdfParser.addPropertyElement(namespaceURI, localName, atts);
                this.pushState(2);
                String parseType = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
                if (parseType == null) break;
                if ("Literal".equals(parseType)) {
                    this.pushState(4);
                    break;
                }
                if (!"Resource".equals(parseType)) break;
                this.pushState(3);
                break;
            }
            case 4: {
                if (qName.startsWith(namespaceURI)) {
                    this.charBuffer.append('<').append(qName).append('>');
                } else {
                    String prefix = null;
                    int prefixLenght = qName.indexOf(58);
                    prefix = prefixLenght > 0 ? qName.substring(0, prefixLenght) : "";
                    if (this.literalNamespaces.contains(prefix)) {
                        this.charBuffer.append('<').append(qName).append('>');
                    } else {
                        if (prefix.length() > 0) {
                            this.charBuffer.append('<').append(qName).append(" xmlns:").append(prefix).append("=\\\"").append(namespaceURI).append("\\\">");
                        } else {
                            this.charBuffer.append('<').append(qName).append(" xmlns").append(prefix).append("=\\\"").append(namespaceURI).append("\\\">");
                        }
                        this.literalNamespaces.add(prefix);
                    }
                }
                this.pushState(4);
                this.rdfParser.pushElement(null);
                break;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        boolean gotNonEmptyString;
        Element e = this.rdfParser.peekElement();
        if (e != null && e instanceof NodeElement && !((NodeElement)e).isExplicit()) {
            this.popState();
            this.rdfParser.popElement();
        }
        if (this.getTopState() == 4) {
            if ((Integer)this.stateStack.get(this.stateStack.size() - 2) == 4) {
                this.charBuffer.append("</").append(qName).append('>');
            } else {
                this.rdfParser.removeElement();
                this.popState();
            }
        }
        String text = null;
        boolean bl = gotNonEmptyString = this.charBuffer.length() > 0;
        if (gotNonEmptyString) {
            text = this.charBuffer.toString();
        }
        this.popState();
        int currentState = this.getTopState();
        if (currentState > 1) {
            if (currentState != 4 && gotNonEmptyString) {
                this.rdfParser.addText(text);
                this.charBuffer = new StringBuffer();
                this.literalNamespaces.clear();
            }
            this.rdfParser.removeElement();
        }
        this.rdfParser.popXmlBase();
    }

    public void setDocumentLocator(Locator locator) {
        this.rdfParser.setLocator(locator);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = 0;
        if (this.getTopState() == 4) {
            this.charBuffer.append(ch, start, length);
        } else if (this.getTopState() == 2) {
            while (i < length) {
                if (ch[start + i] == '\n') {
                    ++i;
                    continue;
                }
                if (ch[start + i] == '\t') {
                    ++i;
                    continue;
                }
                if (ch[start + i] != ' ') break;
                ++i;
            }
            if (i < length) {
                this.charBuffer.append(ch, start, length);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    void pushState(int state) {
        this.stateStack.push(this.getIntegerState(state));
    }

    private int popState() {
        if (!this.stateStack.isEmpty()) {
            return (Integer)this.stateStack.pop();
        }
        return 0;
    }

    private int getTopState() {
        if (!this.stateStack.isEmpty()) {
            return (Integer)this.stateStack.peek();
        }
        return 0;
    }

    private Integer getIntegerState(int state) {
        if (state > INTEGER_STATES.length - 1) {
            return INTEGER_STATES[0];
        }
        return INTEGER_STATES[state];
    }
}

