/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: Individual.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.common.util.EList;

import org.eclipse.eodm.rdf.rdfbase.RDFSResource;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Individual</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Individual#getOWLdifferentFrom <em>OWLdifferentFrom</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Individual#getOWLsameAs <em>OWLsameAs</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getIndividual()
 * @model
 * @generated
 */
public interface Individual extends RDFSResource, Universe {
	/**
	 * Returns the value of the '<em><b>OWLdifferentFrom</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.Individual}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Ldifferent From</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLdifferentFrom</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getIndividual_OWLdifferentFrom()
	 * @model type="org.eclipse.eodm.owl.owlbase.Individual"
	 * @generated
	 */
	EList getOWLdifferentFrom();

	/**
	 * Returns the value of the '<em><b>OWLsameAs</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.Individual}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Lsame As</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLsameAs</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getIndividual_OWLsameAs()
	 * @model type="org.eclipse.eodm.owl.owlbase.Individual"
	 * @generated
	 */
	EList getOWLsameAs();

} // Individual
