/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLBasePackageImpl.java,v 1.1 2007/03/18 08:10:09 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;


import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.impl.EODMImplPackageImpl;
import org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.CardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.ComplementClass;
import org.eclipse.eodm.owl.owlbase.EnumeratedClass;
import org.eclipse.eodm.owl.owlbase.HasValueRestriction;
import org.eclipse.eodm.owl.owlbase.Individual;
import org.eclipse.eodm.owl.owlbase.IntersectionClass;
import org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.OWLAllDifferent;
import org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLDataRange;
import org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.OWLOntologyProperty;
import org.eclipse.eodm.owl.owlbase.OWLRestriction;
import org.eclipse.eodm.owl.owlbase.Property;
import org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.Statement;
import org.eclipse.eodm.owl.owlbase.UnionClass;
import org.eclipse.eodm.owl.owlbase.Universe;
import org.eclipse.eodm.owl.owlbase.util.OWLBaseFactory;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;








/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class OWLBasePackageImpl extends EPackageImpl implements OWLBasePackage {
	/*  *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlOntologyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlGraphEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass statementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass universeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlOntologyPropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlClassEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlRestrictionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlObjectPropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass propertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlDatatypePropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass individualEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlAllDifferentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlDataRangeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass owlAnnotationPropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass enumeratedClassEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass intersectionClassEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unionClassEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass complementClassEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hasValueRestrictionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass allValuesFromRestrictionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass someValuesFromRestrictionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass cardinalityRestrictionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass maxCardinalityRestrictionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass minCardinalityRestrictionEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private OWLBasePackageImpl() {
		super(eNS_URI, OWLBaseFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static OWLBasePackage init() {
		if (isInited) return (OWLBasePackage)EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI);

		// Obtain or create and register package
		OWLBasePackageImpl theowlbasePackage = (OWLBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof OWLBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new OWLBasePackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		EODMImplPackageImpl theeodm2Package = (EODMImplPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) instanceof EODMImplPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) : EODMImplPackage.eINSTANCE);
		RDFWebPackageImpl therdfwebPackage = (RDFWebPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) instanceof RDFWebPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) : RDFWebPackage.eINSTANCE);
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) instanceof RDFBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) : RDFBasePackage.eINSTANCE);
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) instanceof RDFSPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) : RDFSPackage.eINSTANCE);

		// Create package meta-data objects
		theowlbasePackage.createPackageContents();
		theeodm2Package.createPackageContents();
		therdfwebPackage.createPackageContents();
		therdfbasePackage.createPackageContents();
		therdfsPackage.createPackageContents();

		// Initialize created meta-data
		theowlbasePackage.initializePackageContents();
		theeodm2Package.initializePackageContents();
		therdfwebPackage.initializePackageContents();
		therdfbasePackage.initializePackageContents();
		therdfsPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theowlbasePackage.freeze();

		return theowlbasePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLOntology() {
		return owlOntologyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OWLbackwardCompatibleWith() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OWLimports() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OWLversionInfo() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OWLpriorVersion() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OWLincompatibleWith() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OwlGraph() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OwlStatement() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLOntology_OwlUniverse() {
		return (EReference)owlOntologyEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLGraph() {
		return owlGraphEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLGraph_Graphontology() {
		return (EReference)owlGraphEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLGraph_OwlGraphStatement() {
		return (EReference)owlGraphEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStatement() {
		return statementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUniverse() {
		return universeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUniverse_Ontology() {
		return (EReference)universeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLOntologyProperty() {
		return owlOntologyPropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLClass() {
		return owlClassEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOWLClass_IsDeprecated() {
		return (EAttribute)owlClassEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLClass_IsClassKind() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLClass_HasRestrictionKind() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLClass_OWLEquivalentClass() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLClass_OWLdisjointWith() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access.
	 *          This feature is the reverse of {@link #getComplementClass_OWLcomplementOf()}.   
	 */
	public EReference getOWLClass_ComplementClass() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access.
	 *          This feature is the reverse of {@link #getIntersectionClass_OWLintersectionOf()}.   
	 */
	public EReference getOWLClass_IntersectionClass() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(6);
	}
	
	/**
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access.
	 *          This feature is the reverse of {@link #getUnionClass_OWLunionOf()}.
	 */
	public EReference getOWLClass_UnionClass() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(7);
	}
	
	/**
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access.
	 *          This feature is the reverse of {@link #getOWLClass_OWLdisjointWith()}.
	 */
	public EReference getOWLClass_DisjointClass() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(8);
	}
	
	/**
	 * @eodmext This is not part of the ODM 2006-04-03 specification. It is added for convenient access.
	 *          This feature is the reverse of {@link #getOWLClass_OWLEquivalentClass()}.
	 */
	public EReference getOWLClass_EquivalentClass() {
		return (EReference)owlClassEClass.getEStructuralFeatures().get(9);
	}

	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLRestriction() {
		return owlRestrictionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLRestriction_OWLonProperty() {
		return (EReference)owlRestrictionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLObjectProperty() {
		return owlObjectPropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOWLObjectProperty_IsInverseFunctional() {
		return (EAttribute)owlObjectPropertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOWLObjectProperty_IsSymmetric() {
		return (EAttribute)owlObjectPropertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOWLObjectProperty_IsTransitive() {
		return (EAttribute)owlObjectPropertyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLObjectProperty_OWLinverseOf() {
		return (EReference)owlObjectPropertyEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProperty() {
		return propertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProperty_IsPropertyDeprecated() {
		return (EAttribute)propertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProperty_IsFunctional() {
		return (EAttribute)propertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProperty_IsObjectProperty() {
		return (EAttribute)propertyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProperty_IsDatatypeProperty() {
		return (EAttribute)propertyEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProperty_OWLequivalentProperty() {
		return (EReference)propertyEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLDatatypeProperty() {
		return owlDatatypePropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIndividual() {
		return individualEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIndividual_OWLdifferentFrom() {
		return (EReference)individualEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIndividual_OWLsameAs() {
		return (EReference)individualEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLAllDifferent() {
		return owlAllDifferentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLAllDifferent_OWLdistinctMembers() {
		return (EReference)owlAllDifferentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLDataRange() {
		return owlDataRangeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLDataRange_OWLDataRangeOneOf() {
		return (EReference)owlDataRangeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOWLDataRange_Datatype() {
		return (EReference)owlDataRangeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOWLAnnotationProperty() {
		return owlAnnotationPropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEnumeratedClass() {
		return enumeratedClassEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEnumeratedClass_OWLoneOf() {
		return (EReference)enumeratedClassEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIntersectionClass() {
		return intersectionClassEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIntersectionClass_OWLintersectionOf() {
		return (EReference)intersectionClassEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnionClass() {
		return unionClassEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUnionClass_OWLunionOf() {
		return (EReference)unionClassEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getComplementClass() {
		return complementClassEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getComplementClass_OWLcomplementOf() {
		return (EReference)complementClassEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHasValueRestriction() {
		return hasValueRestrictionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHasValueRestriction_HasIndividualValue() {
		return (EReference)hasValueRestrictionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHasValueRestriction_HasLiteralValue() {
		return (EReference)hasValueRestrictionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAllValuesFromRestriction() {
		return allValuesFromRestrictionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAllValuesFromRestriction_AllValuesFromClass() {
		return (EReference)allValuesFromRestrictionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAllValuesFromRestriction_AllValuesFromDataRange() {
		return (EReference)allValuesFromRestrictionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSomeValuesFromRestriction() {
		return someValuesFromRestrictionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSomeValuesFromRestriction_SomeValuesFromClass() {
		return (EReference)someValuesFromRestrictionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSomeValuesFromRestriction_SomeValuesFromDataRange() {
		return (EReference)someValuesFromRestrictionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCardinalityRestriction() {
		return cardinalityRestrictionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCardinalityRestriction_OWLcardinality() {
		return (EReference)cardinalityRestrictionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMaxCardinalityRestriction() {
		return maxCardinalityRestrictionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMaxCardinalityRestriction_OWLmaxCardinality() {
		return (EReference)maxCardinalityRestrictionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMinCardinalityRestriction() {
		return minCardinalityRestrictionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMinCardinalityRestriction_OWLminCardinality() {
		return (EReference)minCardinalityRestrictionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLBaseFactory getowlbaseFactory() {
		return (OWLBaseFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		owlOntologyEClass = createEClass(OWL_ONTOLOGY);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OW_LBACKWARD_COMPATIBLE_WITH);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OW_LIMPORTS);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OW_LVERSION_INFO);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OW_LPRIOR_VERSION);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OW_LINCOMPATIBLE_WITH);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OWL_GRAPH);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OWL_STATEMENT);
		createEReference(owlOntologyEClass, OWL_ONTOLOGY__OWL_UNIVERSE);

		owlGraphEClass = createEClass(OWL_GRAPH);
		createEReference(owlGraphEClass, OWL_GRAPH__GRAPHONTOLOGY);
		createEReference(owlGraphEClass, OWL_GRAPH__OWL_GRAPH_STATEMENT);

		statementEClass = createEClass(STATEMENT);

		universeEClass = createEClass(UNIVERSE);
		createEReference(universeEClass, UNIVERSE__ONTOLOGY);

		owlOntologyPropertyEClass = createEClass(OWL_ONTOLOGY_PROPERTY);

		owlClassEClass = createEClass(OWL_CLASS);
		createEAttribute(owlClassEClass, OWL_CLASS__IS_DEPRECATED);
		createEReference(owlClassEClass, OWL_CLASS__IS_CLASS_KIND);
		createEReference(owlClassEClass, OWL_CLASS__HAS_RESTRICTION_KIND);
		createEReference(owlClassEClass, OWL_CLASS__OWL_EQUIVALENT_CLASS);
		createEReference(owlClassEClass, OWL_CLASS__OW_LDISJOINT_WITH);
		// the following features of OWLClass are added by EODM
		createEReference(owlClassEClass, OWL_CLASS__COMPLEMENT_CLASS);
		createEReference(owlClassEClass, OWL_CLASS__INTERSECTION_CLASS);
		createEReference(owlClassEClass, OWL_CLASS__UNION_CLASS);
		createEReference(owlClassEClass, OWL_CLASS__DISJOINT_CLASS);
		createEReference(owlClassEClass, OWL_CLASS__EQUIVALENT_CLASS);

		owlRestrictionEClass = createEClass(OWL_RESTRICTION);
		createEReference(owlRestrictionEClass, OWL_RESTRICTION__OW_LON_PROPERTY);

		owlObjectPropertyEClass = createEClass(OWL_OBJECT_PROPERTY);
		createEAttribute(owlObjectPropertyEClass, OWL_OBJECT_PROPERTY__IS_INVERSE_FUNCTIONAL);
		createEAttribute(owlObjectPropertyEClass, OWL_OBJECT_PROPERTY__IS_SYMMETRIC);
		createEAttribute(owlObjectPropertyEClass, OWL_OBJECT_PROPERTY__IS_TRANSITIVE);
		createEReference(owlObjectPropertyEClass, OWL_OBJECT_PROPERTY__OW_LINVERSE_OF);

		propertyEClass = createEClass(PROPERTY);
		createEAttribute(propertyEClass, PROPERTY__IS_PROPERTY_DEPRECATED);
		createEAttribute(propertyEClass, PROPERTY__IS_FUNCTIONAL);
		createEAttribute(propertyEClass, PROPERTY__IS_OBJECT_PROPERTY);
		createEAttribute(propertyEClass, PROPERTY__IS_DATATYPE_PROPERTY);
		createEReference(propertyEClass, PROPERTY__OW_LEQUIVALENT_PROPERTY);

		owlDatatypePropertyEClass = createEClass(OWL_DATATYPE_PROPERTY);

		individualEClass = createEClass(INDIVIDUAL);
		createEReference(individualEClass, INDIVIDUAL__OW_LDIFFERENT_FROM);
		createEReference(individualEClass, INDIVIDUAL__OW_LSAME_AS);

		owlAllDifferentEClass = createEClass(OWL_ALL_DIFFERENT);
		createEReference(owlAllDifferentEClass, OWL_ALL_DIFFERENT__OW_LDISTINCT_MEMBERS);

		owlDataRangeEClass = createEClass(OWL_DATA_RANGE);
		createEReference(owlDataRangeEClass, OWL_DATA_RANGE__OWL_DATA_RANGEONE_OF);
		createEReference(owlDataRangeEClass, OWL_DATA_RANGE__DATATYPE);

		owlAnnotationPropertyEClass = createEClass(OWL_ANNOTATION_PROPERTY);

		enumeratedClassEClass = createEClass(ENUMERATED_CLASS);
		createEReference(enumeratedClassEClass, ENUMERATED_CLASS__OW_LONE_OF);

		intersectionClassEClass = createEClass(INTERSECTION_CLASS);
		createEReference(intersectionClassEClass, INTERSECTION_CLASS__OW_LINTERSECTION_OF);

		unionClassEClass = createEClass(UNION_CLASS);
		createEReference(unionClassEClass, UNION_CLASS__OW_LUNION_OF);

		complementClassEClass = createEClass(COMPLEMENT_CLASS);
		createEReference(complementClassEClass, COMPLEMENT_CLASS__OW_LCOMPLEMENT_OF);

		hasValueRestrictionEClass = createEClass(HAS_VALUE_RESTRICTION);
		createEReference(hasValueRestrictionEClass, HAS_VALUE_RESTRICTION__HAS_INDIVIDUAL_VALUE);
		createEReference(hasValueRestrictionEClass, HAS_VALUE_RESTRICTION__HAS_LITERAL_VALUE);

		allValuesFromRestrictionEClass = createEClass(ALL_VALUES_FROM_RESTRICTION);
		createEReference(allValuesFromRestrictionEClass, ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_CLASS);
		createEReference(allValuesFromRestrictionEClass, ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_DATA_RANGE);

		someValuesFromRestrictionEClass = createEClass(SOME_VALUES_FROM_RESTRICTION);
		createEReference(someValuesFromRestrictionEClass, SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_CLASS);
		createEReference(someValuesFromRestrictionEClass, SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_DATA_RANGE);

		cardinalityRestrictionEClass = createEClass(CARDINALITY_RESTRICTION);
		createEReference(cardinalityRestrictionEClass, CARDINALITY_RESTRICTION__OW_LCARDINALITY);

		maxCardinalityRestrictionEClass = createEClass(MAX_CARDINALITY_RESTRICTION);
		createEReference(maxCardinalityRestrictionEClass, MAX_CARDINALITY_RESTRICTION__OW_LMAX_CARDINALITY);

		minCardinalityRestrictionEClass = createEClass(MIN_CARDINALITY_RESTRICTION);
		createEReference(minCardinalityRestrictionEClass, MIN_CARDINALITY_RESTRICTION__OW_LMIN_CARDINALITY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI);
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI);

		// Add supertypes to classes
		owlOntologyEClass.getESuperTypes().add(therdfbasePackage.getRDFSResource());
		owlGraphEClass.getESuperTypes().add(therdfbasePackage.getGraph());
		statementEClass.getESuperTypes().add(therdfbasePackage.getRDFStatement());
		owlOntologyPropertyEClass.getESuperTypes().add(therdfbasePackage.getRDFProperty());
		owlOntologyPropertyEClass.getESuperTypes().add(this.getUniverse());
		owlClassEClass.getESuperTypes().add(therdfsPackage.getRDFSClass());
		owlClassEClass.getESuperTypes().add(this.getUniverse());
		owlRestrictionEClass.getESuperTypes().add(this.getOWLClass());
		owlObjectPropertyEClass.getESuperTypes().add(this.getProperty());
		propertyEClass.getESuperTypes().add(therdfbasePackage.getRDFProperty());
		propertyEClass.getESuperTypes().add(this.getUniverse());
		owlDatatypePropertyEClass.getESuperTypes().add(this.getProperty());
		individualEClass.getESuperTypes().add(therdfbasePackage.getRDFSResource());
		individualEClass.getESuperTypes().add(this.getUniverse());
		owlAllDifferentEClass.getESuperTypes().add(this.getOWLClass());
		owlDataRangeEClass.getESuperTypes().add(therdfsPackage.getRDFSClass());
		owlDataRangeEClass.getESuperTypes().add(this.getUniverse());
		owlAnnotationPropertyEClass.getESuperTypes().add(therdfbasePackage.getRDFProperty());
		owlAnnotationPropertyEClass.getESuperTypes().add(this.getUniverse());
		enumeratedClassEClass.getESuperTypes().add(this.getOWLClass());
		intersectionClassEClass.getESuperTypes().add(this.getOWLClass());
		unionClassEClass.getESuperTypes().add(this.getOWLClass());
		complementClassEClass.getESuperTypes().add(this.getOWLClass());
		hasValueRestrictionEClass.getESuperTypes().add(this.getOWLRestriction());
		allValuesFromRestrictionEClass.getESuperTypes().add(this.getOWLRestriction());
		someValuesFromRestrictionEClass.getESuperTypes().add(this.getOWLRestriction());
		cardinalityRestrictionEClass.getESuperTypes().add(this.getOWLRestriction());
		maxCardinalityRestrictionEClass.getESuperTypes().add(this.getOWLRestriction());
		minCardinalityRestrictionEClass.getESuperTypes().add(this.getOWLRestriction());

		// Initialize classes and features; add operations and parameters
		initEClass(owlOntologyEClass, OWLOntology.class, "OWLOntology", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOWLOntology_OWLbackwardCompatibleWith(), this.getOWLOntology(), null, "OWLbackwardCompatibleWith", null, 0, -1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLOntology_OWLimports(), this.getOWLOntology(), null, "OWLimports", null, 0, -1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLOntology_OWLversionInfo(), therdfbasePackage.getRDFSLiteral(), null, "OWLversionInfo", null, 0, -1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLOntology_OWLpriorVersion(), this.getOWLOntology(), null, "OWLpriorVersion", null, 0, -1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLOntology_OWLincompatibleWith(), this.getOWLOntology(), null, "OWLincompatibleWith", null, 0, -1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLOntology_OwlGraph(), this.getOWLGraph(), this.getOWLGraph_Graphontology(), "owlGraph", null, 1, -1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLOntology_OwlStatement(), this.getStatement(), null, "owlStatement", null, 1, -1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLOntology_OwlUniverse(), this.getUniverse(), this.getUniverse_Ontology(), "owlUniverse", null, 1, 1, OWLOntology.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(owlGraphEClass, OWLGraph.class, "OWLGraph", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOWLGraph_Graphontology(), this.getOWLOntology(), this.getOWLOntology_OwlGraph(), "graphontology", null, 0, -1, OWLGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLGraph_OwlGraphStatement(), this.getStatement(), null, "owlGraphStatement", null, 1, -1, OWLGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(statementEClass, Statement.class, "Statement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(universeEClass, Universe.class, "Universe", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getUniverse_Ontology(), this.getOWLOntology(), this.getOWLOntology_OwlUniverse(), "ontology", null, 1, 1, Universe.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(owlOntologyPropertyEClass, OWLOntologyProperty.class, "OWLOntologyProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(owlClassEClass, OWLClass.class, "OWLClass", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getOWLClass_IsDeprecated(), ecorePackage.getEBoolean(), "isDeprecated", null, 1, 1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_IsClassKind(), ecorePackage.getEObject(), null, "isClassKind", null, 1, 1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_HasRestrictionKind(), ecorePackage.getEObject(), null, "hasRestrictionKind", null, 1, 1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_OWLEquivalentClass(), this.getOWLClass(), this.getOWLClass_EquivalentClass(), "OWLequivalentClass", null, 0, -1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_OWLdisjointWith(), this.getOWLClass(), this.getOWLClass_DisjointClass(), "OWLdisjointWith", null, 0, -1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		// added by EODM
		initEReference(getOWLClass_ComplementClass(), this.getComplementClass(), this.getComplementClass_OWLcomplementOf(), "complementClass", null, 0, -1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_IntersectionClass(), this.getIntersectionClass(), this.getIntersectionClass_OWLintersectionOf(), "intersectionClass", null, 0, -1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_UnionClass(), 	this.getUnionClass(), this.getUnionClass_OWLunionOf(), "unionClass", null, 0, -1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_DisjointClass(), this.getOWLClass(), this.getOWLClass_OWLdisjointWith(), "disjointClass", null, 0, -1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLClass_EquivalentClass(), this.getOWLClass(), this.getOWLClass_OWLEquivalentClass(), "equivalentClass", null, 0, -1, OWLClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		
		initEClass(owlRestrictionEClass, OWLRestriction.class, "OWLRestriction", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOWLRestriction_OWLonProperty(), therdfbasePackage.getRDFProperty(), null, "OWLonProperty", null, 1, 1, OWLRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(owlObjectPropertyEClass, OWLObjectProperty.class, "OWLObjectProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getOWLObjectProperty_IsInverseFunctional(), ecorePackage.getEBoolean(), "isInverseFunctional", null, 1, 1, OWLObjectProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOWLObjectProperty_IsSymmetric(), ecorePackage.getEBoolean(), "isSymmetric", null, 1, 1, OWLObjectProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOWLObjectProperty_IsTransitive(), ecorePackage.getEBoolean(), "isTransitive", null, 1, 1, OWLObjectProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLObjectProperty_OWLinverseOf(), this.getOWLObjectProperty(), null, "OWLinverseOf", null, 0, -1, OWLObjectProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(propertyEClass, Property.class, "Property", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProperty_IsPropertyDeprecated(), ecorePackage.getEBoolean(), "isPropertyDeprecated", null, 1, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProperty_IsFunctional(), ecorePackage.getEBoolean(), "isFunctional", null, 1, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProperty_IsObjectProperty(), ecorePackage.getEBoolean(), "isObjectProperty", null, 1, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEAttribute(getProperty_IsDatatypeProperty(), ecorePackage.getEBoolean(), "isDatatypeProperty", null, 1, 1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEReference(getProperty_OWLequivalentProperty(), this.getProperty(), null, "OWLequivalentProperty", null, 0, -1, Property.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(owlDatatypePropertyEClass, OWLDatatypeProperty.class, "OWLDatatypeProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(individualEClass, Individual.class, "Individual", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIndividual_OWLdifferentFrom(), this.getIndividual(), null, "OWLdifferentFrom", null, 0, -1, Individual.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIndividual_OWLsameAs(), this.getIndividual(), null, "OWLsameAs", null, 0, -1, Individual.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(owlAllDifferentEClass, OWLAllDifferent.class, "OWLAllDifferent", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOWLAllDifferent_OWLdistinctMembers(), this.getIndividual(), null, "OWLdistinctMembers", null, 2, -1, OWLAllDifferent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(owlDataRangeEClass, OWLDataRange.class, "OWLDataRange", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOWLDataRange_OWLDataRangeOneOf(), therdfbasePackage.getRDFSLiteral(), null, "OWLdataRangeOneOf", null, 1, -1, OWLDataRange.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOWLDataRange_Datatype(), therdfsPackage.getRDFSDatatype(), null, "datatype", null, 1, 1, OWLDataRange.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(owlAnnotationPropertyEClass, OWLAnnotationProperty.class, "OWLAnnotationProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(enumeratedClassEClass, EnumeratedClass.class, "EnumeratedClass", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEnumeratedClass_OWLoneOf(), this.getIndividual(), null, "OWLoneOf", null, 0, -1, EnumeratedClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(intersectionClassEClass, IntersectionClass.class, "IntersectionClass", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIntersectionClass_OWLintersectionOf(), this.getOWLClass(), null, "OWLintersectionOf", null, 0, -1, IntersectionClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(unionClassEClass, UnionClass.class, "UnionClass", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getUnionClass_OWLunionOf(), this.getOWLClass(), null, "OWLunionOf", null, 0, -1, UnionClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(complementClassEClass, ComplementClass.class, "ComplementClass", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getComplementClass_OWLcomplementOf(), this.getOWLClass(), null, "OWLcomplementOf", null, 1, 1, ComplementClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(hasValueRestrictionEClass, HasValueRestriction.class, "HasValueRestriction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getHasValueRestriction_HasIndividualValue(), this.getIndividual(), null, "hasIndividualValue", null, 1, 1, HasValueRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHasValueRestriction_HasLiteralValue(), therdfbasePackage.getRDFSLiteral(), null, "hasLiteralValue", null, 1, 1, HasValueRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(allValuesFromRestrictionEClass, AllValuesFromRestriction.class, "AllValuesFromRestriction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAllValuesFromRestriction_AllValuesFromClass(), this.getOWLClass(), null, "allValuesFromClass", null, 1, 1, AllValuesFromRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAllValuesFromRestriction_AllValuesFromDataRange(), this.getOWLDataRange(), null, "allValuesFromDataRange", null, 1, 1, AllValuesFromRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(someValuesFromRestrictionEClass, SomeValuesFromRestriction.class, "SomeValuesFromRestriction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSomeValuesFromRestriction_SomeValuesFromClass(), this.getOWLClass(), null, "someValuesFromClass", null, 1, 1, SomeValuesFromRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSomeValuesFromRestriction_SomeValuesFromDataRange(), this.getOWLDataRange(), null, "someValuesFromDataRange", null, 1, 1, SomeValuesFromRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(cardinalityRestrictionEClass, CardinalityRestriction.class, "CardinalityRestriction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCardinalityRestriction_OWLcardinality(), therdfbasePackage.getTypedLiteral(), null, "OWLcardinality", null, 1, 1, CardinalityRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(maxCardinalityRestrictionEClass, MaxCardinalityRestriction.class, "MaxCardinalityRestriction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMaxCardinalityRestriction_OWLmaxCardinality(), therdfbasePackage.getTypedLiteral(), null, "OWLmaxCardinality", null, 1, 1, MaxCardinalityRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(minCardinalityRestrictionEClass, MinCardinalityRestriction.class, "MinCardinalityRestriction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMinCardinalityRestriction_OWLminCardinality(), therdfbasePackage.getTypedLiteral(), null, "OWLminCardinality", null, 1, 1, MinCardinalityRestriction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create annotations
		// keywords
		createKeywordsAnnotations();
	}

	/**
	 * Initializes the annotations for <b>keywords</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createKeywordsAnnotations() {
		String source = "keywords";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "metamodel", null
		   });
	}

} //OWLBasePackageImpl
