/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFGraphImpl.java,v 1.2 2007/03/18 10:23:39 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.net.URISyntaxException;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.exceptions.AddingTripleException;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.impl.GraphIterator;
import org.eclipse.eodm.impl.InternalCore;
import org.eclipse.eodm.impl.InternalCoreImpl;
import org.eclipse.eodm.impl.ProxyEntity;
import org.eclipse.eodm.impl.RDFFactoryImpl;
import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.rdf.rdfbase.BlankNode;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.util.RDFUtility;
import org.eclipse.eodm.util.Triple;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>RDFGraph</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl#getGraphstatement <em>Graphstatement</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl#getGraphName <em>RDFGraph Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RDFGraphImpl extends RDFSResourceImpl implements RDFGraph {

	protected HashMap entities;
	
	/**
	 * The cached value of the '{@link #getGraphstatement() <em>Graphstatement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphstatement()
	 * @generated
	 * @ordered
	 */
	protected EList graphstatement = null;

	/**
	 * The cached value of the '{@link #getGraphName() <em>RDFGraph Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphName()
	 * @generated
	 * @ordered
	 */
	protected URIReference graphName = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RDFGraphImpl() {
		super();
		this.entities = new HashMap();
				
	}

	public HashMap getEntityHashMap()
	{
		return this.entities;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getGraph();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getGraphstatement() {
		if (graphstatement == null) {
			graphstatement = new EObjectResolvingEList(RDFStatement.class, this, RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT);
		}
		return graphstatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public URIReference getGraphName() {
		return graphName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGraphName(URIReference newGraphName, NotificationChain msgs) {
		URIReference oldGraphName = graphName;
		graphName = newGraphName;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_GRAPH__GRAPH_NAME, oldGraphName, newGraphName);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGraphName(URIReference newGraphName) {
		if (newGraphName != graphName) {
			NotificationChain msgs = null;
			if (graphName != null)
				msgs = ((InternalEObject)graphName).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RDFBasePackage.RDF_GRAPH__GRAPH_NAME, null, msgs);
			if (newGraphName != null)
				msgs = ((InternalEObject)newGraphName).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RDFBasePackage.RDF_GRAPH__GRAPH_NAME, null, msgs);
			msgs = basicSetGraphName(newGraphName, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_GRAPH__GRAPH_NAME, newGraphName, newGraphName));
	}
	public ArrayList getTypeResources( String uri, boolean withSpec )throws UnsupportedViewTypeException
	{
		ArrayList list = new ArrayList();
		HashMap graphEntity = this.getEntityHashMap();
		boolean isType = false;
		for(Iterator iterator = graphEntity.keySet().iterator(); iterator.hasNext();)
		{
			isType = false;
			String keyword = (String)iterator.next();
			InternalCore coreObject  = (InternalCore)graphEntity.get(keyword);
			if(RDFUtility.getEClass().containsKey(uri))
			{
				if(withSpec || coreObject.getUriRef().size()==0||!RDFUtility.getEClass().containsKey(coreObject.getURI()))
				{
					EClass classType = (EClass)RDFUtility.getEClass().get(uri);
					for(Iterator iterator1 = coreObject.getProxyList().iterator();iterator1.hasNext();)
					{
						ProxyEntity pe = (ProxyEntity)iterator1.next();
						if(classType.isSuperTypeOf(pe.getEClass()))
						{
							list.add(pe.getProxyObject());
							isType = true;
							break;
						}
					}
				}
			}
			if(!isType)
			{
				for(int i =0;i< coreObject.getRDFtype().size();i++)
				{
					RDFSResource rdfsResource = (RDFSResource)coreObject.getRDFtype().get(i);
					if(uri.equals(rdfsResource.getURI()))
					{
						if(RDFUtility.getEClass().containsKey(uri))
						{
							list.add(coreObject.forceAsType(((EClass)RDFUtility.getEClass().get(uri)).getInstanceClass()));
						}
						else
						{
							list.add(coreObject.forceAsType(RDFBasePackage.eINSTANCE.getRDFSResource().getInstanceClass()));
						}
					}
				}
			}
			
		}
		if(list.isEmpty())
		{
			return null;
		}
		else
			return list;
	}
	
	/**
	 * Return the Elist of the given type of Resources in current 
	 * @param classType the class type of the resources in current graph required 
	 * @return
	 */
	public ArrayList getTypeResources(String uri)throws UnsupportedViewTypeException
	{
	     return this.getTypeResources(uri,false);
	}
	
	protected void addCustomTriple( Triple triple ) throws UnsupportedViewTypeException 
	{
		RDFSResource subjectResource,objectResource;
		String subjectTag;
		String objectTag;
		subjectTag = triple.isSubjectURI()?triple.getSubjectURI():triple.getSubjectNodeID();
		if(this.entities.containsKey(subjectTag))
		{
			subjectResource = ((RDFSResource)this.entities.get(subjectTag)).asType(RDFSResource.class);
		}
		else
		{
			if(triple.isSubjectURI())
			{
				subjectResource = (RDFSResource)((RDFFactoryImpl)RDFFactory.eINSTANCE).internalCreate(this, RDFSResource.class, triple.getSubjectUriRef());
			}
			else
			{
				subjectResource = RDFFactory.eINSTANCE.createBlankNode(this,triple.getObjectNodeID());
				subjectResource.setNodeID(triple.getSubjectNodeID());
			}
		}
		if(!triple.isObjectLiteral())
		{
			objectTag = triple.isObjectURI()?triple.getObjectURI():triple.getObjectNodeID();
			if(this.entities.containsKey(objectTag))
			{
				objectResource = ((RDFSResource)this.entities.get(objectTag)).asType(RDFSResource.class);
			}
			else
			{
				if(triple.isObjectURI())
				{
					objectResource = (RDFSResource)((RDFFactoryImpl)RDFFactory.eINSTANCE).internalCreate(this, RDFSResource.class, triple.getObjectUriRef());
				}
				else
				{
					objectResource = RDFFactory.eINSTANCE.createBlankNode(this,triple.getObjectNodeID());
					objectResource.setNodeID(triple.getObjectNodeID());
				}
			}				
		}			
		else
		{
			objectResource = triple.getObjectLiteral();	
		}
		subjectResource.getCustomTriples().add(triple);		
	}
	
	public void addTriple(Triple triple)
	throws AddingTripleException, UnsupportedViewTypeException,URISyntaxException
	{
		//triple.print();
		//System.out.println(triple.getSubjectUriRef().getNamespace().getNamespaceValue().getName());
		//System.out.println(triple.getSubjectUriRef().getFragmentIdentifier().getName());
		//Check whether the predicate of the triple is the pre-defined propery in RDF/RDFS.
		if(RDFUtility.getEReferenceList().containsKey(triple.getPredicate()))
		{
			//Get the responding EReference of the predicate.
			EReference predicate = (EReference)RDFUtility.getEReferenceList().get(triple.getPredicate());
			RDFSResource subjectResource,objectResource;
			String subjectTag;
			String objectTag;
			subjectTag = triple.isSubjectURI()?triple.getSubjectURI():triple.getSubjectNodeID();
			//Check whether the subject resource have already been stored in this graph
			if(this.entities.containsKey(subjectTag))
			{
				
				// Retrieve the object stored in the graph
				// Force object consistent with the subject type 
				// implictly defined by the predicate.
				
				subjectResource = (RDFSResource)this.entities.get(subjectTag);			
				subjectResource = subjectResource.forceAsType(predicate.getEContainingClass().getInstanceClass());
			}
			else
			{
				//If the subject resource is not store in this graph
				//The graph will initialize an object with the type implictely defined
				//by the predicate and then store it into the object pool of the graph
				if(triple.isSubjectURI())
				{
					//triple.print();
					subjectResource = (RDFSResource)((RDFFactoryImpl)RDFFactory.eINSTANCE).create(this,predicate.getEContainingClass(),triple.getSubjectUriRef());
				}
				else
				{
					subjectResource = RDFFactory.eINSTANCE.createBlankNode(this,triple.getSubjectNodeID()).forceAsType(predicate.getEContainingClass().getInstanceClass());
				}
			}
			if(!triple.isObjectLiteral())
			{
				objectTag = triple.isObjectURI()?triple.getObjectURI():triple.getObjectNodeID();
				if(this.entities.containsKey(objectTag))
				{
					objectResource = (RDFSResource)this.entities.get(objectTag);
					objectResource = objectResource.forceAsType(predicate.getEReferenceType().getInstanceClass());
				}
				else
				{
					if(triple.isObjectURI())
					{
						objectResource = (RDFSResource)((RDFFactoryImpl)RDFFactory.eINSTANCE).create(this,predicate.getEReferenceType(),triple.getObjectUriRef());
					}
					else
					{
						objectResource = RDFFactory.eINSTANCE.createBlankNode(this,triple.getObjectNodeID()).forceAsType(predicate.getEReferenceType().getInstanceClass());
						objectResource.setNodeID(triple.getObjectNodeID());
					}
				}				
			}			
			else
			{
				RDFSLiteral objLiteral = triple.getObjectLiteral();
				if (  predicate == RDFBasePackage.eINSTANCE.getRDFSResource_RDFScomment() || 
					   predicate == RDFBasePackage.eINSTANCE.getRDFSResource_RDFSlabel() )
					// clone the literal for contaiment properties
					objectResource = (RDFSResource) objLiteral.clone();
				else
					objectResource = objLiteral ;
			}
			//Get the featureid defined in the emf class of the predicate.
			int featureid =  RDFUtility.getFeatureIDbyPredicateURI(triple.getPredicate());
			//Add the relationship defined in the triple to the OO model.
			if(predicate.getUpperBound()==-1)
			{
				((EList)subjectResource.eGet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid))).add(objectResource);
			}
			else if(predicate.getUpperBound()==1)
			{
				subjectResource.eSet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid),objectResource);
			}
		}
		//If the predicate of the triple is customer defined.
		else addCustomTriple( triple );
	}
	
	protected class GraphResourceIterator implements Iterator {

		boolean withSpec ;
		RDFSResource nextResource = null ;
		Iterator objIter = null ;
		InternalCoreImpl currentObj = null ;
		int proxyNum = -1 ;
		HashMap specClasses = null ;
		
		public GraphResourceIterator(boolean withSpec, HashMap specClasses)	{
			this.withSpec = withSpec ;
			this.specClasses = specClasses ; 
			objIter = entities.keySet().iterator() ;
			nextResource = findNext();
		}
		
		public boolean hasNext() {
			return (nextResource != null) ;
		}

		public Object next() {
			if ( ! hasNext() )
				throw new NoSuchElementException();
			RDFSResource retRes = nextResource ;
			nextResource = findNext();
			return retRes ;
		}

		public void remove() {
			throw new UnsupportedOperationException();
		}
		
		protected RDFSResource findNext() {
			boolean found = false ;
			do {
				// find next proxy
				if ( currentObj != null && proxyNum < currentObj.getProxyList().size() - 1 )
				{
					ArrayList plist = currentObj.getProxyList() ;
					int size = plist.size() ;
					while ( ++proxyNum < size )
					{
						found = true ;
						EClass eclass = ((ProxyEntity)plist.get(proxyNum)).getEClass() ;
						for ( int i=0; i<size; i++ )
							if ( i != proxyNum ) {
								EClass ic = ((ProxyEntity)plist.get(i)).getEClass() ;
								if ( eclass.isSuperTypeOf( ic ) ) {
									found = false; 
									break ;
								}
							}
						if ( found ) 
							return (RDFSResource) ((ProxyEntity)plist.get(proxyNum)).getProxyObject() ;
					}
				}
				// find next object
				currentObj = null ;
				while ( objIter.hasNext() ) {
					InternalCoreImpl nextObj = (InternalCoreImpl) entities.get( objIter.next() );
					if ( withSpec || nextObj.getUriRef().size()==0 ||! specClasses.containsKey(nextObj.getURI()) )
					{
						currentObj = nextObj ;
						currentObj.addProxiesForTypes();
						proxyNum = -1 ;
						break ;
					}
				}
				if ( currentObj == null ) break ; // no next object
				
			} while (true) ;
			
			return null ;
		}
	}
	
	public Iterator getAllResources() {
		return getAllResources(false);
	}
	
	public Iterator getAllResources(boolean withSpec) {
		return new GraphResourceIterator(withSpec, RDFUtility.getEClass());
	}
	
	public RDFSResource getRDFSResource(String uri)
	{
		InternalCore coreObject = (InternalCore)entities.get(uri);
		if ( coreObject != null )
			try {
				return coreObject.forceAsType( RDFSResource.class );
			} catch (UnsupportedViewTypeException e) {
				e.printStackTrace();
			}
		return null ;
	}
	/**
	 * Return the ArrayList of {@link org.eclipse.eodm.util.Triple <em>Triple</em>}
	 * Export all triples contained in current graph
	 * @return
	 */
	public ArrayList exportTriples()
	{
		ArrayList triples = new ArrayList();
		for(Iterator iterator = this.getEntityHashMap().keySet().iterator();iterator.hasNext();)
		{
			String uri = (String)iterator.next();
			InternalCore coreObject = (InternalCore)this.getEntityHashMap().get(uri);
			for(Iterator iterator1= RDFUtility.getEReferenceList().keySet().iterator();iterator1.hasNext();)
			{
				String predicate = (String)iterator1.next();
				int featureid = RDFUtility.getFeatureIDbyPredicateURI(predicate);
				if(coreObject.eIsSet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid)))
				{
					EReference reference = (EReference)EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid);
				    if(reference.getUpperBound()==-1)
				    {
				    	EList referedList = (EList)coreObject.eGet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid));				    	
				    	for(int i=0;i<referedList.size();i++)
				    	{
				    		Triple triple  = new Triple();
				    		if(coreObject.getNodeID()!=null&&!coreObject.getNodeID().equals(""))
				    		{
				    			triple.setSubjectNodeID(coreObject.getNodeID());
				    		}
				    		else
				    		{
				    			triple.setSubjectUriRef((URIReference)coreObject.getUriRef().get(0));
				    		}
				    		triple.setPredicate(predicate);				    		
				    		RDFSResource objRes = (RDFSResource) referedList.get(i);
				    		if ( objRes.canAsType( RDFSLiteral.class ))
				    		{
								triple.setObjectLiteral( (RDFSLiteral) objRes );
				    		}
				    		else if( objRes.canAsType( BlankNode.class ) )
				    		{
					    		triple.setObjectNodeID( objRes.getNodeID() );
				    		}
				    		else
				    		{
				    			triple.setObjectUriRef((URIReference)(objRes.getUriRef().get(0)));
				    		}
				    		triples.add(triple);
				    	}
				    }
				    else if(reference.getUpperBound()==1)
				    {
				    	Triple triple  = new Triple();
			    		if(coreObject.getNodeID()!=null&&!coreObject.getNodeID().equals(""))
			    		{
			    			triple.setSubjectNodeID(coreObject.getNodeID());
			    		}
			    		else
			    		{
			    			triple.setSubjectUriRef((URIReference)coreObject.getUriRef().get(0));
			    		}
			    		triple.setPredicate(predicate);
			    		RDFSResource rdfsResource = (RDFSResource)coreObject.eGet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid));
			    		if(rdfsResource instanceof RDFSLiteral)
			    		{
				    		triple.setObjectLiteral((RDFSLiteral)rdfsResource);
			    		}
			    		else if(rdfsResource.getNodeID()!=null&&!rdfsResource.getNodeID().equals(""))
			    		{
			    			triple.setObjectNodeID(rdfsResource.getNodeID());
			    		}
			    		else
			    		{
			    			triple.setObjectUriRef((URIReference)rdfsResource.getUriRef().get(0));
			    		}
			    		triples.add(triple);
				    }
				}
			    
			}
			for(int i= 0;i<coreObject.getCustomTriples().size();i++)
			{
				Triple customerTriple = ((Triple)coreObject.getCustomTriples().get(i)).cloneTriple();
				triples.add(customerTriple);
			}
		}
		return triples;
	}
	/**
     * Delete a triple into the RDFGraph, and the OO based memory model changed correspondly
	 * @param triple the triple to be deleted
	 */
	public void deleteTriple(Triple triple)
	{
		
	}
	/**
	 * Return the Iterator of current graph.
	 * @return 
	 */
	public Iterator getTriples()
	{
		return new GraphIterator(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDF_GRAPH__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.RDF_GRAPH__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDF_GRAPH__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_GRAPH__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_GRAPH__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_GRAPH__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_GRAPH__GRAPH_NAME:
					return basicSetGraphName(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_GRAPH__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case RDFBasePackage.RDF_GRAPH__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case RDFBasePackage.RDF_GRAPH__RD_FTYPE:
				return getRDFtype();
			case RDFBasePackage.RDF_GRAPH__RDF_SMEMBER:
				return getRDFSmember();
			case RDFBasePackage.RDF_GRAPH__NODE_ID:
				return getNodeID();
			case RDFBasePackage.RDF_GRAPH__RDF_SCOMMENT:
				return getRDFScomment();
			case RDFBasePackage.RDF_GRAPH__RDF_SLABEL:
				return getRDFSlabel();
			case RDFBasePackage.RDF_GRAPH__URI_REF:
				return getUriRef();
			case RDFBasePackage.RDF_GRAPH__SUBJECT_STATEMENT:
				return getSubjectStatement();
			case RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT:
				return getGraphstatement();
			case RDFBasePackage.RDF_GRAPH__GRAPH_NAME:
				return getGraphName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_GRAPH__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__NODE_ID:
				setNodeID((String)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT:
				getGraphstatement().clear();
				getGraphstatement().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_GRAPH__GRAPH_NAME:
				setGraphName((URIReference)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_GRAPH__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__RD_FTYPE:
				getRDFtype().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__URI_REF:
				getUriRef().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT:
				getGraphstatement().clear();
				return;
			case RDFBasePackage.RDF_GRAPH__GRAPH_NAME:
				setGraphName((URIReference)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_GRAPH__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case RDFBasePackage.RDF_GRAPH__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case RDFBasePackage.RDF_GRAPH__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case RDFBasePackage.RDF_GRAPH__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case RDFBasePackage.RDF_GRAPH__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case RDFBasePackage.RDF_GRAPH__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case RDFBasePackage.RDF_GRAPH__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case RDFBasePackage.RDF_GRAPH__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case RDFBasePackage.RDF_GRAPH__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
			case RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT:
				return graphstatement != null && !graphstatement.isEmpty();
			case RDFBasePackage.RDF_GRAPH__GRAPH_NAME:
				return graphName != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //RDFGraphImpl
