/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.atl.engine.injectors.ebnf.EBNFInjector2;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModelElement;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlParser {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static AtlParser defaultParser = null;
    private AtlModelHandler amh = AtlModelHandler.getDefault("EMF");
    private ASMModel pbmm = this.amh.getBuiltInMetaModel("Problem");

    private AtlParser() {
    }

    public static AtlParser getDefault() {
        if (defaultParser == null) {
            defaultParser = new AtlParser();
        }
        return defaultParser;
    }

    public ASMModel parseToModel(InputStream in) {
        return this.parseToModelWithProblems(in)[0];
    }

    public ASMModel[] parseToModelWithProblems(InputStream in) {
        ASMModel[] ret = new ASMModel[2];
        ASMModel atlmm = this.amh.getAtl();
        try {
            ret[0] = ASMEMFModel.newASMEMFModel((String)"temp", (String)"temp", (ASMEMFModel)((ASMEMFModel)atlmm), null);
            ret[1] = this.amh.newModel("pb", "pb", this.pbmm);
            EBNFInjector2 ebnfi = new EBNFInjector2();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("name", "ATL");
            params.put("problems", (String)ret[1]);
            ebnfi.inject(ret[0], in, params);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public EObject parse(InputStream in) {
        return this.parseWithProblems(in)[0];
    }

    public EObject[] parseWithProblems(InputStream in) {
        EObject[] ret = null;
        EObject retUnit = null;
        Set pbs = null;
        ASMModel[] parsed = this.parseToModelWithProblems(in);
        ASMModel atlmodel = parsed[0];
        ASMModel problems = parsed[1];
        if (atlmodel instanceof ASMEMFModel) {
            Set modules = atlmodel.getElementsByType("Unit");
            if (modules.size() > 0) {
                retUnit = ((ASMEMFModelElement)modules.iterator().next()).getObject();
            }
            pbs = problems.getElementsByType("Problem");
        } else {
            Set o = atlmodel.getElementsByType("Unit");
            logger.info(o.toString());
        }
        if (pbs != null) {
            ret = new EObject[1 + pbs.size()];
            int k = 1;
            Iterator i = pbs.iterator();
            while (i.hasNext()) {
                ret[k++] = ((ASMEMFModelElement)i.next()).getObject();
            }
        } else {
            ret = new EObject[]{retUnit};
        }
        return ret;
    }
}

