/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.service.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.service.core.ServiceMessages;
import org.eclipse.m2m.atl.service.core.ServiceTransformationUtil;
import org.eclipse.m2m.atl.service.core.configuration.ComposedTransformationConfiguration;
import org.eclipse.m2m.atl.service.core.configuration.SingleTransformationConfiguration;
import org.eclipse.m2m.atl.service.core.configuration.TransformationConfiguration;
import org.eclipse.m2m.atl.service.core.exception.ServiceException;
import org.eclipse.m2m.atl.service.core.nestedElements.Transformation;

public class ServiceExtensionManager {
    private List transformationConfigurations = new ArrayList();

    private ServiceExtensionManager() {
        String isM3Value;
        IConfigurationElement[] elementsMetamodel;
        IConfigurationElement[] elementsFileExtension;
        TransformationConfiguration tc;
        int j;
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            throw new RuntimeException(ServiceMessages.getString("ServiceExtensionManager.0"));
        }
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.service.core.transformation");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < elements.length) {
                tc = new SingleTransformationConfiguration(elements[j].getAttribute("path"), elements[j].getAttribute("name"), extensions[i].getNamespaceIdentifier());
                elementsFileExtension = elements[j].getChildren("fileExtension");
                int k = 0;
                while (k < elementsFileExtension.length) {
                    tc.addFileExtension(elementsFileExtension[k].getAttribute("value"));
                    ++k;
                }
                elementsMetamodel = elements[j].getChildren("metamodel");
                int k2 = 0;
                while (k2 < elementsMetamodel.length) {
                    isM3Value = elementsMetamodel[k2].getAttribute("isMetametamodel");
                    boolean isM3 = false;
                    if (isM3Value != null) {
                        isM3 = new Boolean(isM3Value);
                    }
                    ((SingleTransformationConfiguration)tc).addMetamodel(elementsMetamodel[k2].getAttribute("name"), elementsMetamodel[k2].getAttribute("path"), elementsMetamodel[k2].getAttribute("nsUri"), isM3, "EMF");
                    ++k2;
                }
                IConfigurationElement[] elementsInModel = elements[j].getChildren("inModel");
                int k3 = 0;
                while (k3 < elementsInModel.length) {
                    ((SingleTransformationConfiguration)tc).addInModel(elementsInModel[k3].getAttribute("name"), elementsInModel[k3].getAttribute("path"), elementsInModel[k3].getAttribute("metamodel"), new Boolean(elementsInModel[k3].getAttribute("inWorkspace")));
                    ++k3;
                }
                IConfigurationElement[] elementsOutModel = elements[j].getChildren("outModel");
                int k4 = 0;
                while (k4 < elementsOutModel.length) {
                    ((SingleTransformationConfiguration)tc).addOutModel(elementsOutModel[k4].getAttribute("name"), elementsOutModel[k4].getAttribute("fileName"), elementsOutModel[k4].getAttribute("metamodel"));
                    ++k4;
                }
                this.transformationConfigurations.add(tc);
                ++j;
            }
            ++i;
        }
        point = registry.getExtensionPoint("org.eclipse.m2m.atl.service.core.composedTransformations");
        extensions = point.getExtensions();
        i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < elements.length) {
                tc = new ComposedTransformationConfiguration(elements[j].getAttribute("name"), extensions[i].getNamespaceIdentifier());
                elementsFileExtension = elements[j].getChildren("fileExtension");
                int k = 0;
                while (k < elementsFileExtension.length) {
                    tc.addFileExtension(elementsFileExtension[k].getAttribute("value"));
                    ++k;
                }
                elementsMetamodel = elements[j].getChildren("load.metamodel");
                int k5 = 0;
                while (k5 < elementsMetamodel.length) {
                    isM3Value = elementsMetamodel[k5].getAttribute("isMetametamodel");
                    boolean isM3 = false;
                    if (isM3Value != null) {
                        isM3 = new Boolean(isM3Value);
                    }
                    ((ComposedTransformationConfiguration)tc).addMetamodel(elementsMetamodel[k5].getAttribute("name"), elementsMetamodel[k5].getAttribute("path"), elementsMetamodel[k5].getAttribute("nsUri"), isM3, "EMF");
                    ++k5;
                }
                ArrayList<String> notPreLoadedModels = new ArrayList<String>();
                IConfigurationElement[] elementsInModel = elements[j].getChildren("load.model");
                int k6 = 0;
                while (k6 < elementsInModel.length) {
                    boolean isInWorkspace = new Boolean(elementsInModel[k6].getAttribute("inWorkspace"));
                    ((ComposedTransformationConfiguration)tc).addInModel(elementsInModel[k6].getAttribute("name"), elementsInModel[k6].getAttribute("path"), elementsInModel[k6].getAttribute("metamodel"), isInWorkspace);
                    if (isInWorkspace) {
                        notPreLoadedModels.add(elementsInModel[k6].getAttribute("name"));
                    }
                    ++k6;
                }
                IConfigurationElement[] elementsTransformation = elements[j].getChildren("transformation");
                int k7 = 0;
                while (k7 < elementsTransformation.length) {
                    Transformation t = new Transformation(elementsTransformation[k7].getAttribute("path"));
                    IConfigurationElement[] subElementsTransformation = elementsTransformation[k7].getChildren("inModel");
                    int l = 0;
                    while (l < subElementsTransformation.length) {
                        t.addInModel(subElementsTransformation[l].getAttribute("name"), subElementsTransformation[l].getAttribute("model"));
                        if (notPreLoadedModels.contains(subElementsTransformation[l].getAttribute("model"))) {
                            t.addInNotPreloadedList(subElementsTransformation[l].getAttribute("model"));
                        }
                        ++l;
                    }
                    subElementsTransformation = elementsTransformation[k7].getChildren("outModel");
                    l = 0;
                    while (l < subElementsTransformation.length) {
                        t.addOutModel(subElementsTransformation[l].getAttribute("name"), subElementsTransformation[l].getAttribute("model"), subElementsTransformation[l].getAttribute("metamodel"));
                        ++l;
                    }
                    ((ComposedTransformationConfiguration)tc).addTransformation(t);
                    ++k7;
                }
                IConfigurationElement[] elementsApplyMarker = elements[j].getChildren("applyMarker");
                int k8 = 0;
                while (k8 < elementsApplyMarker.length) {
                    String globalModelName = elementsApplyMarker[k8].getAttribute("model");
                    ((ComposedTransformationConfiguration)tc).addApplyMarker(globalModelName);
                    ++k8;
                }
                IConfigurationElement[] elementsOutModel = elements[j].getChildren("save.model");
                int k9 = 0;
                while (k9 < elementsOutModel.length) {
                    String globalModelName = elementsOutModel[k9].getAttribute("model");
                    String fileName = elementsOutModel[k9].getAttribute("path");
                    IConfigurationElement[] elementsExtractor = elementsOutModel[k9].getChildren("extractor");
                    if (elementsExtractor.length == 0) {
                        ((ComposedTransformationConfiguration)tc).addModelToSave(globalModelName, fileName);
                    } else if (elementsExtractor.length == 1) {
                        HashMap<String, String> extractorParams = new HashMap<String, String>();
                        IConfigurationElement[] elementsParams = elementsExtractor[0].getChildren("param");
                        int l = 0;
                        while (l < elementsParams.length) {
                            extractorParams.put(elementsParams[l].getAttribute("key"), elementsParams[l].getAttribute("value"));
                            ++l;
                        }
                        ((ComposedTransformationConfiguration)tc).addModelToSave(globalModelName, fileName, elementsExtractor[0].getAttribute("type"), extractorParams);
                    } else {
                        throw new RuntimeException(ServiceMessages.getString("ServiceExtensionManager.1"));
                    }
                    ++k9;
                }
                this.transformationConfigurations.add(tc);
                ++j;
            }
            ++i;
        }
        point = registry.getExtensionPoint("org.eclipse.m2m.atl.service.core.asl");
        extensions = point.getExtensions();
        i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < elements.length) {
                this.transformationConfigurations.add(this.createComposedTransformationConfigurationFromASLExtensionPoint(elements[j].getAttribute("name"), elements[j].getAttribute("path"), extensions[i].getNamespaceIdentifier()));
                ++j;
            }
            ++i;
        }
    }

    private ComposedTransformationConfiguration createComposedTransformationConfigurationFromASLExtensionPoint(String configName, String aslPath, String pluginId) {
        AtlModelHandler amh = AtlModelHandler.getDefault((String)"EMF");
        try {
            ASMModel aslMM = ServiceTransformationUtil.loadModel(amh, "ASL", amh.getMof(), "resources/ASL/ASL.ecore", "", false, false, "org.eclipse.m2m.atl.service.core");
            ASMModel sample = ServiceTransformationUtil.ebnfInjection("sample-ASL", aslPath, amh, aslMM, new HashMap(), "resources/ASL/ASL-importer.jar", "ASL", "org.eclipse.m2m.atl.service.core");
            Set modelElements = sample.getElementsByType("ASL");
            for (ASMModelElement me : modelElements) {
                ASMSequence seq = (ASMSequence)me.get(null, "operations");
                new ComposedTransformationConfiguration("configName", "pluginId");
                for (ASMModelElement me2 : seq) {
                    String metaObjectName = me2.getMetaobject().getName();
                    if (metaObjectName.equals("loadMetamodel") || metaObjectName.equals("loadModel") || metaObjectName.equals("atl") || metaObjectName.equals("applyMarker")) continue;
                    metaObjectName.equals("saveModel");
                }
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ServiceExtensionManager getInstance() {
        return ServiceExtensionManagerHolder.instance;
    }

    public List getTransformationConfigurations() {
        return this.transformationConfigurations;
    }

    /* synthetic */ ServiceExtensionManager(ServiceExtensionManager serviceExtensionManager) {
        this();
    }

    private static class ServiceExtensionManagerHolder {
        private static ServiceExtensionManager instance = new ServiceExtensionManager(null);

        private ServiceExtensionManagerHolder() {
        }
    }
}

