/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOStandardLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.impl.ModuleImpl;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.BagTypeOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CollectionTypeOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.DictionaryOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ElementOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ExceptionOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.IntegerOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ListOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ModelOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ObjectOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.OclAnyOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.OrderedSetTypeOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.RealOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.SequenceTypeOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.SetTypeOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.StatusOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.StdlibModuleOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.StringOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.TransformationOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.StdlibFactory;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLFactory;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleType;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EcoreOCLStandardLibrary;
import org.eclipse.ocl.ecore.TemplateParameterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalStdLibrary
extends AbstractQVTStdlib
implements QVTOStandardLibrary {
    public static final String NS_URI = "http://www.eclipse.org/m2m/qvt/oml/1.0.0/Stdlib";
    private static final String QVT_STDLIB_MODULE_NAME = "Stdlib";
    private static final EPackage ECORE_OCL_LIB = new EcoreOCLStandardLibrary().getOCLStdLibPackage();
    private static final String OCL_STDLIB_MODULE_NAME = ECORE_OCL_LIB.getName();
    public static final QvtOperationalStdLibrary INSTANCE = QvtOperationalStdLibrary.createLibrary();
    private final EClassifier OBJECT;
    private final EClassifier ELEMENT;
    private final EClass MODEL;
    private final EClass TRANSFORMATION;
    private EClass STATUS;
    private EClass EXCEPTION;
    private EClass ASSERTION_FAILED;
    private EClassifier LIST;
    private EClassifier KEY_T;
    private EClassifier COMMON_T;
    private DictionaryType DICTIONARY;
    private OrderedTupleType ORDERED_TUPLE;
    private final Library fStdlibModule = QvtOperationalStdLibrary.createLibrary("Stdlib");
    private final StdlibFactory fFactory;
    private final QvtOperationalModuleEnv fEnv;
    private final Map<String, EClassifier> fTypeAliasMap;
    private final Map<List<String>, EClassifier> fRegisteredClassifiers;

    static {
        try {
            INSTANCE.defineStandardOperations();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    private QvtOperationalStdLibrary() {
        this.fStdlibModule.setNsURI(NS_URI);
        this.fEnv = new QvtOperationalModuleEnv((EPackage.Registry)new EPackageRegistryImpl(), null);
        this.fEnv.setContextModule(this.fStdlibModule);
        this.fFactory = new StdlibFactory(this);
        assert (this.fStdlibModule.eResource() != null);
        this.fStdlibModule.eResource().setURI(URI.createURI((String)this.fStdlibModule.getNsURI()));
        this.ELEMENT = this.createClass("Element", true);
        this.EXCEPTION = this.createClass("Exception", false);
        this.ASSERTION_FAILED = this.createClass("AssertionFailed", false);
        this.ASSERTION_FAILED.getESuperTypes().add((Object)this.EXCEPTION);
        this.MODEL = this.createModelClass("Model");
        this.ORDERED_TUPLE = this.createOrderedTuple();
        this.OBJECT = this.createClass("Object", true);
        this.STATUS = this.createClass("Status", false);
        this.TRANSFORMATION = this.createClass("Transformation", true);
        this.LIST = this.createListType();
        this.DICTIONARY = this.createDictionaryType();
        this.COMMON_T = this.createTemplateParameter("CommonT");
        this.fTypeAliasMap = QvtOperationalStdLibrary.createTypeAliasMap(this.fEnv);
        this.fRegisteredClassifiers = new HashMap<List<String>, EClassifier>();
        EPackage.Registry.INSTANCE.put((Object)this.fStdlibModule.getNsURI(), (Object)this.fStdlibModule);
    }

    private void defineStandardOperations() {
        this.define(new StringOperations(this));
        this.define(new ModelOperations(this));
        this.define(new OclAnyOperations(this));
        this.define(new ObjectOperations(this));
        this.define(new ElementOperations(this));
        this.define(new StdlibModuleOperations(this));
        this.define(new IntegerOperations(this));
        this.define(new RealOperations(this));
        this.define(new TransformationOperations(this));
        this.define(new StatusOperations(this));
        this.define(new ListOperations(this));
        this.define(new DictionaryOperations(this));
        this.define(new ExceptionOperations(this));
        this.define(CollectionTypeOperations.getAllOperations(this));
        this.define(SetTypeOperations.getAllOperations(this));
        this.define(OrderedSetTypeOperations.getAllOperations(this));
        this.define(BagTypeOperations.getAllOperations(this));
        this.define(SequenceTypeOperations.getAllOperations(this));
        ((ModuleImpl)((Object)this.fStdlibModule)).freeze();
    }

    @Override
    public QVTOEnvironment getEnvironment() {
        return this.fEnv;
    }

    @Override
    public StdlibFactory getStdlibFactory() {
        return this.fFactory;
    }

    public void importTo(QvtOperationalEnv env) {
        env.addImport(ImportKind.EXTENSION, this.fEnv);
    }

    @Override
    public Library getStdLibModule() {
        return this.fStdlibModule;
    }

    @Override
    public EClassifier getList() {
        return this.LIST;
    }

    @Override
    public EClassifier getDictionary() {
        return this.DICTIONARY;
    }

    @Override
    public EClassifier getOrderedTupleType() {
        return this.ORDERED_TUPLE;
    }

    @Override
    public EClassifier getKeyT() {
        return this.KEY_T;
    }

    @Override
    public EClassifier getCommonT() {
        return this.COMMON_T;
    }

    @Override
    public EClass getModelClass() {
        return this.MODEL;
    }

    @Override
    public EClass getStatusClass() {
        return this.STATUS;
    }

    @Override
    public EClass getExceptionClass() {
        return this.EXCEPTION;
    }

    @Override
    public EClass getAssertionFailedClass() {
        return this.ASSERTION_FAILED;
    }

    @Override
    public EClass getTransformationClass() {
        return this.TRANSFORMATION;
    }

    @Override
    public EClass getModuleType() {
        return ExpressionsPackage.eINSTANCE.getModule();
    }

    @Override
    public EClassifier getElementType() {
        return this.ELEMENT;
    }

    @Override
    public EClassifier getObject() {
        return this.OBJECT;
    }

    public ModelType createModel(String name) {
        ModelType modelType = ExpressionsFactory.eINSTANCE.createModelType();
        modelType.setName(name);
        modelType.setInstanceClass(ModelInstance.class);
        modelType.getESuperTypes().add((Object)INSTANCE.getModelClass());
        return modelType;
    }

    public static Library createLibrary(String name) {
        Library lib = ExpressionsFactory.eINSTANCE.createLibrary();
        lib.setInstanceClass(ModuleInstance.class);
        lib.setEFactoryInstance((EFactory)new ModuleInstanceFactory());
        lib.setName(name);
        return lib;
    }

    public OperationalTransformation createTransformation(String name) {
        OperationalTransformation transf = ExpressionsFactory.eINSTANCE.createOperationalTransformation();
        transf.setInstanceClass(TransformationInstance.class);
        transf.setEFactoryInstance((EFactory)new ModuleInstanceFactory());
        transf.setName(name);
        EClass transformationBase = this.getTransformationClass();
        transf.getESuperTypes().add((Object)transformationBase);
        return transf;
    }

    public EClassifier lookupClassifier(List<String> names) {
        if (this.fRegisteredClassifiers.containsKey(names)) {
            return this.fRegisteredClassifiers.get(names);
        }
        EClassifier eClassifier = this.lookupClassifierImpl(names);
        this.fRegisteredClassifiers.put(names, eClassifier);
        return eClassifier;
    }

    private EClassifier lookupClassifierImpl(List<String> names) {
        int size = names.size();
        if (size == 0 || size > 2) {
            return null;
        }
        if (size == 1 || QVT_STDLIB_MODULE_NAME.equals(names.get(0))) {
            String typeName = names.get(size - 1);
            EClassifier aliasedType = this.getTypeAlias(typeName);
            return aliasedType != null ? aliasedType : this.fStdlibModule.getEClassifier(typeName);
        }
        if (size == 2 && OCL_STDLIB_MODULE_NAME.equals(names.get(0))) {
            String typeName = names.get(size - 1);
            return ECORE_OCL_LIB.getEClassifier(typeName);
        }
        return null;
    }

    private void define(AbstractContextualOperations ... typeOperations) {
        AbstractContextualOperations[] abstractContextualOperationsArray = typeOperations;
        int n = typeOperations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractContextualOperations nextOperations = abstractContextualOperationsArray[n2];
            nextOperations.define(this.fEnv);
            ++n2;
        }
    }

    private EClassifier createTemplateParameter(String name) {
        assert (this.fStdlibModule != null);
        assert (name != null);
        TemplateParameterType result = EcoreFactory.eINSTANCE.createTemplateParameterType();
        result.setName(name);
        this.fStdlibModule.getEClassifiers().add((Object)result);
        return result;
    }

    private EClass createClass(String name, boolean isAbstract) {
        assert (this.fStdlibModule != null);
        assert (name != null);
        EClass result = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEClass();
        result.setName(name);
        result.setAbstract(isAbstract);
        this.fStdlibModule.getEClassifiers().add((Object)result);
        return result;
    }

    private EClass createModelClass(String name) {
        assert (this.fStdlibModule != null);
        assert (name != null);
        ModelType result = ExpressionsFactory.eINSTANCE.createModelType();
        result.setName(name);
        result.setAbstract(false);
        this.fStdlibModule.getEClassifiers().add((Object)result);
        return result;
    }

    private OrderedTupleType createOrderedTuple() {
        OrderedTupleType result = ImperativeOCLFactory.eINSTANCE.createOrderedTupleType();
        result.setName("OrderedTupleType(T)");
        result.getElementType().add((Object)((EClassifier)this.getOCLStdLib().getT()));
        this.fStdlibModule.getEClassifiers().add((Object)result);
        return result;
    }

    private ListType createListType() {
        ListType result = this.getStdlibFactory().createList((EClassifier)this.getOCLStdLib().getT());
        this.fStdlibModule.getEClassifiers().add((Object)result);
        return result;
    }

    private DictionaryType createDictionaryType() {
        this.KEY_T = this.createTemplateParameter("KeyT");
        DictionaryType result = this.fFactory.createDictionary(this.KEY_T, (EClassifier)this.getOCLStdLib().getT());
        this.fStdlibModule.getEClassifiers().add((Object)result);
        return result;
    }

    private static QvtOperationalStdLibrary createLibrary() {
        try {
            QvtOperationalStdLibrary lib = new QvtOperationalStdLibrary();
            return lib;
        }
        catch (Error e) {
            e.printStackTrace();
            return null;
        }
    }

    private EClassifier getTypeAlias(String typeName) {
        return this.fTypeAliasMap.get(typeName);
    }

    private static Map<String, EClassifier> createTypeAliasMap(QvtOperationalEnv env) {
        HashMap<String, EClassifier> result = new HashMap<String, EClassifier>();
        result.put("Any", (EClassifier)env.getOCLStandardLibrary().getOclAny());
        result.put("Void", (EClassifier)env.getOCLStandardLibrary().getOclVoid());
        return result;
    }
}

