/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.xml;

import java.io.IOException;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.internal.xml.XMLElement;

public class XMLReportNodeHandler
implements IReportVisitor {
    private final XMLElement element;
    private final ICoverageNode node;

    public XMLReportNodeHandler(XMLElement element, ICoverageNode node) throws IOException {
        this.element = element;
        this.node = node;
        element.attr("name", node.getName());
        this.insertElementsBefore(element);
    }

    protected void insertElementsBefore(XMLElement element) throws IOException {
    }

    void insertElementsAfter(XMLElement element) throws IOException {
    }

    public IReportVisitor visitChild(final ICoverageNode node) throws IOException {
        ICoverageNode.ElementType type = node.getElementType();
        switch (type) {
            case GROUP: 
            case BUNDLE: {
                return new XMLReportNodeHandler(this.element.element("group"), node);
            }
            case PACKAGE: {
                return new XMLReportNodeHandler(this.element.element("package"), node);
            }
            case CLASS: {
                return new XMLReportNodeHandler(this.element.element("class"), node);
            }
            case METHOD: {
                XMLElement methodChild = this.element.element("method");
                IMethodCoverage methodNode = (IMethodCoverage)node;
                methodChild.attr("desc", methodNode.getDesc());
                int line = methodNode.getFirstLine();
                if (line != -1) {
                    methodChild.attr("line", line);
                }
                return new XMLReportNodeHandler(methodChild, node);
            }
            case SOURCEFILE: {
                return new XMLReportNodeHandler(this.element.element("sourcefile"), node){

                    protected void insertElementsAfter(XMLElement element) throws IOException {
                        XMLReportNodeHandler.writeLines((ISourceNode)node, element);
                    }
                };
            }
        }
        throw new AssertionError((Object)type);
    }

    public final void visitEnd(ISourceFileLocator sourceFileLocator) throws IOException {
        this.insertElementsAfter(this.element);
        for (ICoverageNode.CounterEntity counterEntity : ICoverageNode.CounterEntity.values()) {
            this.createCounterElement(counterEntity);
        }
        this.element.close();
    }

    private void createCounterElement(ICoverageNode.CounterEntity counterEntity) throws IOException {
        ICounter counter = this.node.getCounter(counterEntity);
        if (counter.getTotalCount() > 0) {
            XMLElement counterNode = this.element.element("counter");
            counterNode.attr("type", counterEntity.name());
            counterNode.attr("covered", counter.getCoveredCount());
            counterNode.attr("missed", counter.getMissedCount());
            counterNode.close();
        }
    }

    private static void writeLines(ISourceNode source, XMLElement parent) throws IOException {
        int last = source.getLastLine();
        for (int nr = source.getFirstLine(); nr <= last; ++nr) {
            ILine line = source.getLine(nr);
            if (line.getStatus() == 0) continue;
            XMLElement element = parent.element("line");
            element.attr("nr", nr);
            ICounter insn = line.getInstructionCounter();
            element.attr("mi", insn.getMissedCount());
            element.attr("ci", insn.getCoveredCount());
            ICounter branches = line.getBranchCounter();
            element.attr("mb", branches.getMissedCount());
            element.attr("cb", branches.getCoveredCount());
        }
    }
}

