/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Locale;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.report.internal.html.HTMLElement;

class SourceHighlighter {
    private static final int LINENR_WIDTH = 5;
    private final Locale locale;
    private String tabReplacement;
    private String lang;

    public SourceHighlighter(Locale locale) {
        this.locale = locale;
        this.setTabWidth(4);
        this.lang = "java";
    }

    public void setTabWidth(int width) {
        char[] blanks = new char[width];
        Arrays.fill(blanks, ' ');
        this.tabReplacement = new String(blanks);
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    public void render(HTMLElement parent, ISourceNode source, Reader contents) throws IOException {
        String line;
        HTMLElement pre = parent.pre("source lang-" + this.lang);
        BufferedReader lineBuffer = new BufferedReader(contents);
        int nr = 0;
        while ((line = lineBuffer.readLine()) != null) {
            this.renderLineNr(pre, ++nr);
            this.renderCodeLine(pre, line, source.getLine(nr));
        }
    }

    private void renderLineNr(HTMLElement pre, int nr) throws IOException {
        String linestr = String.valueOf(nr);
        HTMLElement linespan = pre.span("nr", "L" + linestr);
        for (int i = linestr.length(); i < 5; ++i) {
            linespan.text("\u00a0");
        }
        linespan.text(linestr);
    }

    private void renderCodeLine(HTMLElement pre, String linesrc, ILine line) throws IOException {
        this.highlight(pre, line).text(linesrc.replace("\t", this.tabReplacement));
        pre.text("\n");
    }

    HTMLElement highlight(HTMLElement pre, ILine line) throws IOException {
        String style;
        switch (line.getStatus()) {
            case 1: {
                style = "nc";
                break;
            }
            case 2: {
                style = "fc";
                break;
            }
            case 3: {
                style = "pc";
                break;
            }
            default: {
                return pre;
            }
        }
        ICounter branches = line.getBranchCounter();
        switch (branches.getStatus()) {
            case 1: {
                return this.span(pre, style, "bnc", "All %2$d branches missed.", branches);
            }
            case 2: {
                return this.span(pre, style, "bfc", "All %2$d branches covered.", branches);
            }
            case 3: {
                return this.span(pre, style, "bpc", "%1$d of %2$d branches missed.", branches);
            }
        }
        return pre.span(style);
    }

    private HTMLElement span(HTMLElement parent, String style1, String style2, String title, ICounter branches) throws IOException {
        HTMLElement span = parent.span(style1 + " " + style2);
        Integer missed = branches.getMissedCount();
        Integer total = branches.getTotalCount();
        span.attr("title", String.format(this.locale, title, missed, total));
        return span;
    }
}

