/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.oprofile.core.model.OpModelSymbol;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSymbol;
import org.eclipse.swt.graphics.Image;

public class UiModelImage
implements IUiModelElement {
    private IUiModelElement _parent;
    private OpModelImage _image;
    private UiModelSymbol[] _symbols;
    private int _totalCount;
    private int _depCount;

    public UiModelImage(IUiModelElement parent, OpModelImage image, int totalCount, int depCount) {
        this._parent = parent;
        this._image = image;
        this._symbols = null;
        this._totalCount = totalCount;
        this._depCount = depCount;
        this.refreshModel();
    }

    private void refreshModel() {
        OpModelSymbol[] dataModelSymbols = this._image.getSymbols();
        if (dataModelSymbols != null) {
            this._symbols = new UiModelSymbol[dataModelSymbols.length];
            int i = 0;
            while (i < dataModelSymbols.length) {
                this._symbols[i] = new UiModelSymbol(this, dataModelSymbols[i], this._totalCount);
                ++i;
            }
        }
    }

    public String toString() {
        if (this._image.getCount() == -1) {
            return OprofileUiMessages.getString("opxmlParse.error.multipleImages");
        }
        double countPercentage = (double)(this._image.getCount() - this._depCount) / (double)this._totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.percentage.in") + this._image.getName();
    }

    public String getLabelText() {
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        IUiModelElement[] children = null;
        if (this._symbols != null) {
            children = new IUiModelElement[this._symbols.length];
            int i = 0;
            while (i < this._symbols.length) {
                children[i] = this._symbols[i];
                ++i;
            }
        }
        return children;
    }

    public boolean hasChildren() {
        return this._symbols != null && this._symbols.length != 0;
    }

    public IUiModelElement getParent() {
        return this._parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/image.gif").createImage();
    }
}

