/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.ParentHistogramCanvas;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class HistogramCanvasKeyListener
implements KeyListener {
    private ParentHistogramCanvas parentCanvas = null;
    private boolean isShiftPressed = false;

    public HistogramCanvasKeyListener(ParentHistogramCanvas newCanvas) {
        this.parentCanvas = newCanvas;
    }

    public void keyPressed(KeyEvent event) {
        switch (event.keyCode) {
            case 131072: {
                this.isShiftPressed = true;
                break;
            }
            case 0x1000003: {
                this.moveWindowPosition(-1);
                break;
            }
            case 0x1000004: {
                this.moveWindowPosition(1);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent event) {
        switch (event.keyCode) {
            case 131072: {
                this.isShiftPressed = false;
                break;
            }
        }
    }

    public void moveWindowPosition(int displacementFactor) {
        if (this.isShiftPressed) {
            displacementFactor = (int)((double)displacementFactor * 10.0);
        }
        this.parentCanvas.moveWindow(displacementFactor);
    }
}

