/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.views;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.systemtap.ui.dashboard.DashboardAdapter;
import org.eclipse.linuxtools.systemtap.ui.dashboard.DashboardComposite;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.UpdateManager;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.ITabListener;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DashboardView
extends ViewPart {
    private ArrayList<DashboardComposite> composites;
    private ArrayList<String> moduleNames;
    public static ArrayList<String> allModuleNames = null;
    private ArrayList<ITabListener> tabListeners;
    private UpdateManager updater;
    private CTabFolder scriptFolder;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView";

    public DashboardView() {
        LogManager.logDebug((String)"Start DashboardView:", (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
        this.composites = new ArrayList();
        this.tabListeners = new ArrayList();
        this.moduleNames = new ArrayList();
        LogManager.logDebug((String)"End DashboardView:", (Object)((Object)this));
    }

    public void createComposite(String title) {
        CTabItem item = new CTabItem(this.scriptFolder, 64);
        item.setText(title);
        Composite parent = new Composite((Composite)this.scriptFolder, 0);
        parent.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 255));
        DashboardComposite comp = new DashboardComposite(parent, 2048);
        IPreferenceStore p = DashboardPlugin.getDefault().getPreferenceStore();
        int delay = p.getInt("DashboardUpdateDelay");
        this.updater = new UpdateManager(delay);
        this.composites.add(comp);
        this.moduleNames.add(title);
        item.setControl((Control)parent);
        this.scriptFolder.setSelection(item);
        this.fireTabOpenEvent();
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 0);
        data2.top = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        Composite cmpGraph = new Composite(parent, 0);
        cmpGraph.setLayoutData((Object)data2);
        cmpGraph.setLayout((Layout)new FormLayout());
        FormData data3 = new FormData();
        data3.left = new FormAttachment(0, 0);
        data3.top = new FormAttachment(0, 0);
        data3.right = new FormAttachment(100, 0);
        data3.bottom = new FormAttachment(6, 0);
        this.scriptFolder = new CTabFolder(cmpGraph, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.scriptFolder.setLayoutData((Object)data);
        this.scriptFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DashboardView.this.fireTabChangedEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.scriptFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void restore(CTabFolderEvent e) {
            }

            public void showList(CTabFolderEvent e) {
            }

            public void minimize(CTabFolderEvent e) {
            }

            public void maximize(CTabFolderEvent e) {
            }

            public void close(CTabFolderEvent e) {
                DashboardView.this.composites.remove(DashboardView.this.scriptFolder.indexOf((CTabItem)e.item));
                DashboardView.this.moduleNames.remove(DashboardView.this.scriptFolder.indexOf((CTabItem)e.item));
                DashboardView.this.fireTabCloseEvent();
            }
        });
        Display display = parent.getShell().getDisplay();
        this.scriptFolder.setSelectionBackground(display.getSystemColor(15));
        this.scriptFolder.setMaximizeVisible(true);
        this.scriptFolder.setSelectionForeground(display.getSystemColor(2));
        LogManager.logDebug((String)"End createPartControl", (Object)((Object)this));
    }

    public void setFocus() {
    }

    public DashboardAdapter createGraph(GraphData gd, IDataSet ds, String moduleName) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        Cursor cursor = new Cursor((Device)disp, 1);
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(cursor);
        int index = this.searchModuleNames(moduleName);
        DashboardAdapter adapter = null;
        if (index == -1) {
            this.createComposite(moduleName);
            index = this.searchModuleNames(moduleName);
        }
        adapter = new DashboardAdapter(this.composites.get(index), gd, ds, moduleName);
        this.updater.addUpdateListener((IUpdateListener)adapter.getGraph());
        this.composites.get(index).add(adapter);
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(null);
        cursor.dispose();
        return adapter;
    }

    private int searchModuleNames(String moduleName) {
        int i = 0;
        while (i < this.moduleNames.size()) {
            if (moduleName.equals(this.moduleNames.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public UpdateManager getUpdater() {
        return this.updater;
    }

    public void removeGraph(DashboardAdapter graph, String moduleName) {
        int index = this.searchModuleNames(moduleName);
        this.composites.get(index).remove(graph);
        graph.dispose();
    }

    public void closeComposite(String moduleName) {
        int index = this.searchModuleNames(moduleName);
        if (this.composites.get(index).getusedSlots() <= 0) {
            this.scriptFolder.getItem(index).dispose();
            this.moduleNames.remove(index);
            this.composites.remove(index);
        }
    }

    public void addTabListener(ITabListener listener) {
        this.tabListeners.add(listener);
    }

    public void removeTabListener(ITabListener listener) {
        this.tabListeners.remove(listener);
    }

    private void fireTabCloseEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabClosed();
            ++i;
        }
    }

    private void fireTabOpenEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabOpened();
            ++i;
        }
    }

    private void fireTabChangedEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabChanged();
            ++i;
        }
    }

    public void dispose() {
        LogManager.logDebug((String)"Start dispose:", (Object)((Object)this));
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        super.dispose();
        if (this.scriptFolder != null) {
            this.scriptFolder.dispose();
        }
        this.scriptFolder = null;
        if (this.composites != null) {
            this.composites.removeAll(this.composites);
        }
        this.composites = null;
        this.scriptFolder = null;
        if (this.tabListeners != null) {
            this.tabListeners.removeAll(this.tabListeners);
        }
        this.tabListeners = null;
        LogManager.logDebug((String)"End dispose:", (Object)((Object)this));
    }

    public static void addmodulename(String str) {
        if (allModuleNames == null) {
            allModuleNames = new ArrayList();
        }
        allModuleNames.add(str);
    }
}

