/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractSTTableViewer
extends AbstractSTViewer {
    public AbstractSTTableViewer(Composite parent) {
        super(parent, 68354);
    }

    public AbstractSTTableViewer(Composite parent, boolean init) {
        super(parent, 68354, init);
    }

    public AbstractSTTableViewer(Composite parent, int style) {
        super(parent, style, true);
    }

    public AbstractSTTableViewer(Composite parent, int style, boolean init) {
        super(parent, style, init);
    }

    @Override
    protected ColumnViewer createViewer(Composite parent, int style) {
        return new TableViewer(this.createTable(parent, style));
    }

    protected Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        return table;
    }

    @Override
    protected void createColumns() {
        Table table = this.getViewer().getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < this.getAllFields().length) {
            ISTDataViewersField field = this.getAllFields()[i];
            TableColumn tc = new TableColumn(table, field.getAlignment(), i);
            tc.setText(field.getColumnHeaderText());
            tc.setToolTipText(field.getColumnHeaderTooltip());
            tc.setImage(field.getColumnHeaderImage());
            tc.setWidth(field.getPreferredWidth());
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.addSelectionListener(this.createHeaderListener());
            tc.setData((Object)field);
            TableViewerColumn viewerColumn = new TableViewerColumn(this.getViewer(), tc);
            viewerColumn.setLabelProvider(this.createColumnLabelProvider((Item)tc));
            ++i;
        }
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Table table = (Table)e.widget;
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item != null) {
                    int i = 0;
                    while (i < table.getColumnCount()) {
                        Rectangle bounds;
                        ISTDataViewersField field = AbstractSTTableViewer.this.getAllFields()[i];
                        if (field.isHyperLink(item.getData()) && (bounds = item.getBounds(i)).contains(e.x, e.y)) {
                            AbstractSTTableViewer.this.handleHyperlink(field, item.getData());
                        }
                        ++i;
                    }
                }
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Table table = (Table)e.widget;
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                int i = 0;
                while (i < table.getColumnCount()) {
                    Rectangle bounds;
                    ISTDataViewersField field = AbstractSTTableViewer.this.getAllFields()[i];
                    Cursor cursor = null;
                    if (field.isHyperLink(item.getData()) && (bounds = item.getBounds(i)).contains(e.x, e.y)) {
                        cursor = new Cursor((Device)e.display, 21);
                        table.setCursor(cursor);
                        return;
                    }
                    cursor = new Cursor((Device)e.display, 0);
                    table.setCursor(cursor);
                    ++i;
                }
            }
        });
    }

    @Override
    public Item[] getColumns() {
        return this.getViewer().getTable().getColumns();
    }

    @Override
    public void updateDirectionIndicator(Item column) {
        this.getViewer().getTable().setSortColumn((TableColumn)column);
        if (this.getTableSorter().getTopPriorityDirection() == 1) {
            this.getViewer().getTable().setSortDirection(128);
        } else {
            this.getViewer().getTable().setSortDirection(1024);
        }
    }

    @Override
    public int[] getColumnOrder() {
        return this.getViewer().getTable().getColumnOrder();
    }

    @Override
    protected void setColumnOrder(int[] order) {
        this.getViewer().getTable().setColumnOrder(order);
    }

    @Override
    public int getColumnIndex(Item column) {
        return this.getViewer().getTable().indexOf((TableColumn)column);
    }

    @Override
    public int getColumnWidth(Item column) {
        return ((TableColumn)column).getWidth();
    }

    @Override
    public void setColumnResizable(Item column, boolean resizable) {
        ((TableColumn)column).setResizable(resizable);
    }

    @Override
    public void setColumnWidth(Item column, int width) {
        ((TableColumn)column).setWidth(width);
    }

    public TableViewer getViewer() {
        return (TableViewer)super.getViewer();
    }

    public void handleHyperlink(ISTDataViewersField field, Object data) {
    }
}

