/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets.TraceColorScheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TmfTimeLegend
extends TitleAreaDialog {
    public static final int[] interactionColors = new int[]{43, 44, 63, 62, 64};
    protected TraceColorScheme colors = new TraceColorScheme();
    private TmfTimeAnalysisProvider ifUtil;

    public static void open(Shell parent, TmfTimeAnalysisProvider rifUtil) {
        new TmfTimeLegend(parent, rifUtil).open();
    }

    public TmfTimeLegend(Shell parent, TmfTimeAnalysisProvider rifUtil) {
        super(parent);
        this.ifUtil = rifUtil;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dlgArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.createThreadStatesGroup(composite);
        this.setMessage(Messages.TmfTimeLegend_LEGEND);
        this.setTitle(Messages.TmfTimeLegend_TRACE_STATES_TITLE);
        TmfTimeLegend.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        return composite;
    }

    private void createThreadStatesGroup(Composite composite) {
        Group gs = new Group(composite, 0);
        gs.setText(Messages.TmfTimeLegend_TRACE_STATES);
        GridData gd = new GridData(4, 4, true, true);
        gs.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        gs.setLayout((Layout)layout);
        int i = 0;
        while (i < TraceColorScheme.getStateColors().length) {
            TmfTimeAnalysisProvider.StateColor stateColor = TraceColorScheme.getStateColors()[i];
            String stateName = this.ifUtil.getStateName(stateColor);
            if (stateName != "Not mapped") {
                Bar bar = new Bar((Composite)gs, i);
                gd = new GridData();
                gd.widthHint = 40;
                gd.heightHint = 20;
                gd.verticalIndent = 8;
                bar.setLayoutData(gd);
                Label name = new Label((Composite)gs, 0);
                name.setText(stateName);
                gd = new GridData();
                gd.horizontalIndent = 10;
                gd.verticalIndent = 8;
                name.setLayoutData((Object)gd);
            }
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TmfTimeLegend_WINDOW_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    class Arrow
    extends Canvas {
        public static final int HEIGHT = 12;
        public static final int DX = 3;
        private Color color;

        public Arrow(Composite parent, int colorIdx) {
            super(parent, 0);
            this.color = TmfTimeLegend.this.colors.getColor(colorIdx);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Arrow.this.draw(event.gc);
                }
            });
        }

        private void draw(GC gc) {
            int y1;
            int y0;
            Rectangle r = this.getClientArea();
            gc.setForeground(this.color);
            if (r.height > 12) {
                y0 = (r.height - 12) / 2;
                y1 = y0 + 12;
            } else {
                y0 = 0;
                y1 = r.height;
            }
            gc.drawLine(3, y0, 3, y1);
            gc.drawLine(0, y0 + 3, 3, y0);
            gc.drawLine(6, y0 + 3, 3, y0);
        }
    }

    class Bar
    extends Canvas {
        private Color color;

        public Bar(Composite parent, int colorIdx) {
            super(parent, 0);
            this.color = TmfTimeLegend.this.colors.getColor(colorIdx);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Bar.this.draw(event.gc);
                }
            });
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.color);
            gc.fillRectangle(r);
            gc.setForeground(TmfTimeLegend.this.colors.getColor(43));
            gc.drawRectangle(0, 0, r.width - 1, r.height - 1);
        }
    }

    class Mark
    extends Canvas {
        public static final int DX = 3;
        private Color color;

        public Mark(Composite parent, int colorIdx) {
            super(parent, 0);
            this.color = TmfTimeLegend.this.colors.getColor(colorIdx);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Mark.this.draw(event.gc);
                }
            });
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.color);
            int y = (r.height - 3) / 2;
            int[] nArray = new int[6];
            nArray[1] = y;
            nArray[2] = 3;
            nArray[3] = y + 3;
            nArray[4] = 6;
            nArray[5] = y;
            int[] c = nArray;
            gc.fillPolygon(c);
        }
    }
}

