/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelectTracePathDialog
extends Dialog {
    private Text fPath = null;
    private String fPathName = null;
    private String fTracePathError = null;
    private Label fErrorLabel = null;

    public SelectTracePathDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SeletctTracePathDialog_Title);
        newShell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 16);
        GridLayout mainLayout = new GridLayout(1, true);
        composite.setLayout((Layout)mainLayout);
        this.fErrorLabel = new Label(composite, 16384);
        this.fErrorLabel.setLayoutData((Object)new GridData(4, 2, true, false, 6, 1));
        this.fErrorLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        Group group = new Group(composite, 8);
        group.setText(Messages.ConfigureTraceDialog_Trace_Location);
        group.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        GridLayout groupLayout = new GridLayout(6, true);
        group.setLayout((Layout)groupLayout);
        Label tracePathLabel = new Label((Composite)group, 16384);
        tracePathLabel.setText(Messages.ConfigureTraceDialog_Trace_Path);
        tracePathLabel.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.fPath = new Text((Composite)group, 16384);
        this.fPath.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        this.fPath.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Button ok = SelectTracePathDialog.this.getButton(0);
                ok.setEnabled(SelectTracePathDialog.this.validatePathName(SelectTracePathDialog.this.fPath.getText()));
            }
        });
        Button browseButton = new Button((Composite)group, 8);
        browseButton.setText(String.valueOf(Messages.ConfigureTraceDialog_Browse) + "...");
        browseButton.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        browseButton.setEnabled(true);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dialog = new DirectoryDialog(SelectTracePathDialog.this.getShell());
                String newPath = dialog.open();
                if (newPath != null) {
                    SelectTracePathDialog.this.fPath.setText(newPath);
                }
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button ok = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        ok.setEnabled(false);
    }

    protected void okPressed() {
        this.fPathName = this.fPath.getText();
        File newDir = new File(this.fPathName);
        if (!newDir.exists()) {
            try {
                newDir.mkdirs();
            }
            catch (Exception exception) {}
        }
        super.okPressed();
    }

    private boolean validatePathName(String path) {
        if (path.length() > 0) {
            File file;
            char c0 = path.charAt(0);
            if (c0 != '/') {
                this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Path;
                this.fErrorLabel.setText(this.fTracePathError);
                return false;
            }
            String[] folders = path.split("/");
            int i = 0;
            while (i < folders.length) {
                char[] chars = folders[i].toCharArray();
                int x = 0;
                while (x < chars.length) {
                    char c = chars[x];
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Folder;
                        this.fErrorLabel.setText(this.fTracePathError);
                        return false;
                    }
                    ++x;
                }
                ++i;
            }
            if (path.length() > 1) {
                i = 0;
                while (i < path.length() - 1) {
                    if (path.charAt(i) == '/' && path.charAt(i + 1) == '/') {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Multiple_Seps;
                        this.fErrorLabel.setText(this.fTracePathError);
                        return false;
                    }
                    ++i;
                }
            }
            if ((file = new File(path)).isFile()) {
                this.fTracePathError = Messages.ConfigureTraceDialog_Error_File_Exists;
                this.fErrorLabel.setText(this.fTracePathError);
                return false;
            }
            if (path.length() > 1 && !file.getParentFile().canWrite()) {
                this.fTracePathError = Messages.ConfigureTraceDialog_Error_Can_Not_Write;
                this.fErrorLabel.setText(this.fTracePathError);
                return false;
            }
        }
        this.fErrorLabel.setText("");
        this.fTracePathError = "";
        return true;
    }

    public String getTracePath() {
        return this.fPathName;
    }
}

