/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.graphing.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.graphing.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphing.structures.GraphDisplaySet;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.ITabListener;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class SaveGraphImageAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private IAction action;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction act) {
        LogManager.logDebug((String)"Start run", (Object)((Object)this));
        AbstractChartBuilder g = this.getGraph();
        try {
            PlatformUI.getWorkbench().getDisplay().update();
        }
        catch (SWTException swte) {
            LogManager.logCritical((String)("SWTException SaveGraphImageAction.run:" + swte.getMessage()), (Object)((Object)this));
        }
        if (g == null) {
            this.displayError(Localization.getString("SaveGraphImageAction.CanNotGetGraph"));
            return;
        }
        ImageData image = this.getImage(g);
        if (image == null) {
            this.displayError(Localization.getString("SaveGraphImageAction.CanNotCreateImage"));
            return;
        }
        String path = this.getFile();
        if (path == null) {
            return;
        }
        this.save(image, path);
        LogManager.logDebug((String)"End run", (Object)((Object)this));
    }

    public AbstractChartBuilder getGraph() {
        LogManager.logDebug((String)"Start getGraph", (Object)((Object)this));
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
        AbstractChartBuilder g = null;
        GraphDisplaySet gds = ((GraphSelectorView)ivp).getActiveDisplaySet();
        if (gds != null) {
            g = gds.getActiveGraph();
        }
        LogManager.logDebug((String)"End getGraph", (Object)((Object)this));
        return g;
    }

    public ImageData getImage(AbstractChartBuilder canvas) {
        LogManager.logDebug((String)"Start getImage", (Object)((Object)this));
        GC gc = new GC((Drawable)canvas);
        Image image = new Image((Device)canvas.getDisplay(), canvas.getSize().x, canvas.getSize().y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageData data = image.getImageData();
        image.dispose();
        LogManager.logDebug((String)"End getImage", (Object)((Object)this));
        return data;
    }

    public String getFile() {
        LogManager.logDebug((String)"Start getFile", (Object)((Object)this));
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 8192);
        dialog.setText(Localization.getString("SaveGraphImageAction.NewFile"));
        LogManager.logInfo((String)"Init FileDialog", (Object)dialog);
        LogManager.logDebug((String)"End getFile", (Object)((Object)this));
        return dialog.open();
    }

    public void save(ImageData image, String path) {
        LogManager.logDebug((String)"Start save", (Object)((Object)this));
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image};
        loader.save(path, 4);
        LogManager.logDebug((String)"End save", (Object)((Object)this));
    }

    private void displayError(String message) {
        LogManager.logInfo((String)"Initializing", MessageDialog.class);
        MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("SaveGraphImageAction.Problem"), (String)message);
        LogManager.logInfo((String)"Disposing", MessageDialog.class);
    }

    public void selectionChanged(IAction a, ISelection s) {
        this.action = a;
        this.setEnablement(false);
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
        if (ivp != null) {
            final GraphSelectorView gsv = (GraphSelectorView)ivp;
            gsv.addTabListener(new ITabListener(){

                public void tabClosed() {
                    if (gsv.getActiveDisplaySet() == null || gsv.getActiveDisplaySet().getActiveGraph() == null) {
                        SaveGraphImageAction.this.setEnablement(false);
                    }
                }

                public void tabOpened() {
                    gsv.getActiveDisplaySet().addTabListener(new ITabListener(){

                        public void tabClosed() {
                            if (gsv.getActiveDisplaySet().getActiveGraph() == null) {
                                SaveGraphImageAction.this.setEnablement(false);
                            }
                        }

                        public void tabOpened() {
                            if (gsv.getActiveDisplaySet().getActiveGraph() != null) {
                                SaveGraphImageAction.this.setEnablement(true);
                            }
                        }

                        public void tabChanged() {
                            if (gsv.getActiveDisplaySet() == null || gsv.getActiveDisplaySet().getActiveGraph() == null) {
                                SaveGraphImageAction.this.setEnablement(false);
                            } else {
                                SaveGraphImageAction.this.setEnablement(true);
                            }
                        }
                    });
                }

                public void tabChanged() {
                    if (gsv.getActiveDisplaySet() == null || gsv.getActiveDisplaySet().getActiveGraph() == null) {
                        SaveGraphImageAction.this.setEnablement(false);
                    } else {
                        SaveGraphImageAction.this.setEnablement(true);
                    }
                }
            });
        }
    }

    private void setEnablement(boolean enable) {
        this.action.setEnabled(enable);
    }

    public void dispose() {
        LogManager.logInfo((String)"Start dispose", (Object)((Object)this));
        LogManager.logInfo((String)"Disposing", MessageDialog.class);
        this.fWindow = null;
        this.action = null;
        LogManager.logDebug((String)"End dispose", (Object)((Object)this));
    }
}

