/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IAddContextDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class BaseAddContextHandler
extends BaseControlViewHandler {
    protected CommandParameter fParam = null;

    public abstract void addContexts(CommandParameter var1, List<String> var2, IProgressMonitor var3) throws ExecutionException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final CommandParameter param = this.fParam.clone();
            UIJob getJob = new UIJob(Messages.TraceControl_GetContextJob){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        List<String> availableContexts = param.getSession().getContextList(monitor);
                        final IAddContextDialog dialog = TraceControlDialogFactory.getInstance().getAddContextDialog();
                        dialog.setAvalibleContexts(availableContexts);
                        if (dialog.open() != 0 || dialog.getContexts().isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        Job addJob = new Job(Messages.TraceControl_AddContextJob){

                            protected IStatus run(IProgressMonitor monitor) {
                                ExecutionException error = null;
                                try {
                                    List<String> contextNames = dialog.getContexts();
                                    BaseAddContextHandler.this.addContexts(param, contextNames, monitor);
                                }
                                catch (ExecutionException e) {
                                    error = e;
                                }
                                BaseAddContextHandler.this.refresh(param);
                                if (error != null) {
                                    return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_AddContextFailure, (Throwable)error);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        addJob.setUser(true);
                        addJob.schedule();
                    }
                    catch (ExecutionException e) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_GetContextFailure, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            getJob.setUser(false);
            getJob.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }
}

