/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.util.Log;

public class DialogUtil {
    public static void displayCoreErrorDialog(Shell parent, String msg, CoreException coreEx) {
        if (msg == null) {
            msg = coreEx.getMessage();
        }
        String title = Messages.MessageDialog_errorTitle;
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        IStatus status = coreEx.getStatus();
        ErrorDialog.openError((Shell)parent, (String)title, (String)msg, (IStatus)status);
        Log.error(msg, coreEx);
    }

    public static void displayErrorMessage(Shell parent, String msg, Throwable ex) {
        String title = Messages.MessageDialog_errorTitle;
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        MessageDialog.openError((Shell)parent, (String)title, (String)msg);
        Log.error(msg, ex);
    }

    public static void displayErrorMessage(Shell parent, String msg, Object[] variables, Throwable ex) {
        if (msg == null) {
            return;
        }
        if (variables != null) {
            msg = NLS.bind((String)msg, (Object[])variables);
        }
        DialogUtil.displayErrorMessage(parent, msg, ex);
    }

    public static void displayWarningMessage(Shell parent, String msg) {
        String title = Messages.MessageDialog_warningTitle;
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        MessageDialog.openWarning((Shell)parent, (String)title, (String)msg);
        Log.warning(msg);
    }

    public static void displayWarningMessage(Shell parent, String msg, Object[] variables) {
        if (msg == null) {
            return;
        }
        if (variables != null) {
            msg = NLS.bind((String)msg, (Object[])variables);
        }
        DialogUtil.displayWarningMessage(parent, msg);
    }

    public static void displayInfoMessage(Shell parent, String msg) {
        String title = Messages.MessageDialog_infoTitle;
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        MessageDialog.openInformation((Shell)parent, (String)title, (String)msg);
        Log.info(msg);
    }

    public static void displayInfoMessage(Shell parent, String msg, Object[] variables) {
        if (msg == null) {
            return;
        }
        if (variables != null) {
            msg = NLS.bind((String)msg, (Object[])variables);
        }
        DialogUtil.displayInfoMessage(parent, msg);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveShell() {
        Display display = DialogUtil.getCurrentDisplay();
        Shell activeShell = display.getActiveShell();
        if (activeShell == null) {
            return DialogUtil.getActiveWorkbenchWindow().getShell();
        }
        return activeShell;
    }

    public static Display getCurrentDisplay() {
        Display display = Display.getCurrent();
        if (display != null) {
            return display;
        }
        return Display.getDefault();
    }
}

