/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.ListItem;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMNodeLinkedList {
    private long offset;
    private PDOMLinkage linkage;
    private boolean allowsNull;
    private static final int FIRST_MEMBER = 0;
    protected static final int RECORD_SIZE = 4;

    public PDOMNodeLinkedList(PDOMLinkage linkage, long offset, boolean allowsNulls) {
        this.offset = offset;
        this.linkage = linkage;
        this.allowsNull = allowsNulls;
    }

    public PDOMNodeLinkedList(PDOMLinkage linkage, long offset) {
        this(linkage, offset, false);
    }

    protected int getRecordSize() {
        return 4;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        Database db = this.linkage.getDB();
        long firstItem = db.getRecPtr(this.offset + 0L);
        if (firstItem == 0L) {
            return;
        }
        long item = firstItem;
        do {
            PDOMNode node;
            long record;
            if ((record = db.getRecPtr(item + 8L)) == 0L) {
                if (!this.allowsNull) {
                    throw new NullPointerException();
                }
                node = null;
            } else {
                node = PDOMNode.load(this.linkage.getPDOM(), record);
            }
            if (visitor.visit(node) && node != null) {
                node.accept(visitor);
            }
            visitor.leave(node);
        } while ((item = db.getRecPtr(item + 0L)) != firstItem);
    }

    private ListItem getFirstMemberItem() throws CoreException {
        Database db = this.linkage.getDB();
        long item = db.getRecPtr(this.offset + 0L);
        return item != 0L ? new ListItem(db, item) : null;
    }

    public PDOMNode getNodeAt(int pos) throws CoreException {
        Database db = this.linkage.getDB();
        long firstItem = db.getRecPtr(this.offset + 0L);
        if (firstItem == 0L) {
            return null;
        }
        long item = firstItem;
        do {
            if (--pos >= 0) continue;
            long record = db.getRecPtr(item + 8L);
            if (record == 0L) {
                if (!this.allowsNull) {
                    throw new NullPointerException();
                }
                return null;
            }
            return PDOMNode.load(this.linkage.getPDOM(), record);
        } while ((item = db.getRecPtr(item + 0L)) != firstItem);
        return null;
    }

    public void addMember(PDOMNode member) throws CoreException {
        this.addMember(this.allowsNull && member == null ? 0L : member.getRecord());
    }

    protected void addMember(long record) throws CoreException {
        Database db = this.linkage.getDB();
        ListItem firstMember = this.getFirstMemberItem();
        if (firstMember == null) {
            firstMember = new ListItem(db);
            firstMember.setItem(record);
            firstMember.setNext(firstMember);
            firstMember.setPrev(firstMember);
            db.putRecPtr(this.offset + 0L, firstMember.getRecord());
        } else {
            ListItem newMember = new ListItem(db);
            newMember.setItem(record);
            ListItem prevMember = firstMember.getPrev();
            prevMember.setNext(newMember);
            firstMember.setPrev(newMember);
            newMember.setPrev(prevMember);
            newMember.setNext(firstMember);
        }
    }

    public void deleteListItems() throws CoreException {
        ListItem item = this.getFirstMemberItem();
        if (item != null) {
            long firstRec = item.record;
            do {
                ListItem nextItem = item.getNext();
                item.delete();
                item = nextItem;
            } while (item.record != firstRec && item.record != 0L);
        }
    }
}

