# Here is code that implements gtk_object_new, gtk_object_set

%{

static void PyGtk_DestroyNotify(PyObject *o) {
    Py_DECREF(o);
}

static void PyGtk_CallbackMarshal(GtkObject *o, PyObject *func, int nargs,
                                                          GtkArg *args) {
    PyObject *ret, *a, *params;

    a = GtkArg_to_Tuple(nargs, args);
    if (a == NULL) {
        PyErr_Clear();
        fprintf(stderr, "can't decode params -- callback not run\n");
        return;
    }
    if (o == NULL)
      params = a;
    else {
      ret = PyTuple_New(1);
      PyTuple_SetItem(ret, 0, PyGtk_New(o));
      params = PySequence_Concat(ret, a);
      Py_DECREF(ret); Py_DECREF(a);
    }
   ret = PyObject_CallObject(func, params);
    Py_DECREF(params);
    if (ret == NULL)
        fprintf(stderr, "exception ignored\n");
    else
        Py_DECREF(ret);
}

static void PyGtk_object_set(GtkObject *o, PyObject *dict) {
    int len, i;
    PyObject *keys, *key, *item;
    char *name;
    GtkType tp;
    GtkArg arg;
 
    keys = PyDict_Keys(dict);
    len = PyList_Size(keys);
    for (i=0; i < len; i++) {
        key = PyList_GetItem(keys, i);
        if (!PyString_Check(key)) {
            fprintf(stderr, "Key not a string\n");
            continue;
        }
        item = PyDict_GetItem(dict, key);
        name = PyString_AsString(key);
        tp = gtk_object_get_arg_type(name);
        if (tp == GTK_TYPE_INVALID) {
            Py_DECREF(item);
            fprintf(stderr, "Invalid key - %s\n", name);
            continue;
        }

        arg.type = tp;
        arg.name = name;
/*	fprintf(stderr, "%s - %s => %s\n", name, gtk_type_name(tp), gtk_type_name(GTK_FUNDAMENTAL_TYPE(tp)));*/
#define type_check(t) if (!t) { Py_DECREF(item); \
     fprintf(stderr, "%s: Expected %s, got %s -- ignoring\n", name, \
     gtk_type_name(GTK_FUNDAMENTAL_TYPE(tp)),item->ob_type->tp_name);continue;} 
        switch (GTK_FUNDAMENTAL_TYPE(tp)) {
            case GTK_TYPE_CHAR:
                type_check(PyString_Check(item))
                GTK_VALUE_CHAR(arg) = *PyString_AsString(item);
                break;
            case GTK_TYPE_BOOL:
                type_check(PyInt_Check(item))
                GTK_VALUE_BOOL(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_INT:
                type_check(PyInt_Check(item))
                GTK_VALUE_INT(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_UINT:
                type_check(PyInt_Check(item))
                GTK_VALUE_UINT(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_LONG:
                type_check(PyInt_Check(item))
                GTK_VALUE_LONG(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_ULONG:
                type_check(PyInt_Check(item))
                GTK_VALUE_ULONG(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_FLOAT:
                type_check(PyFloat_Check(item))
                GTK_VALUE_FLOAT(arg) = PyFloat_AsDouble(item);
                break;
            case GTK_TYPE_STRING:
                type_check(PyString_Check(item))
                GTK_VALUE_STRING(arg) = PyString_AsString(item);
                break;
            case GTK_TYPE_ENUM:
                type_check(PyInt_Check(item))
                GTK_VALUE_ENUM(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_FLAGS:
                type_check(PyInt_Check(item))
                GTK_VALUE_FLAGS(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_BOXED:
                type_check(PyGtkTooltips_Check(item) ||
                           PyGtkAccelerator_Check(item) || 
                           PyGtkStyle_Check(item) || PyGdkFont_Check(item) ||
                           PyGdkColor_Check(item) || PyGdkEvent_Check(item))
                GTK_VALUE_BOXED(arg) = ((PyGtkStyle_Object *)item)->obj;
                break;
            case GTK_TYPE_FOREIGN:
                Py_INCREF(item);
                GTK_VALUE_FOREIGN(arg).data = item;
                GTK_VALUE_FOREIGN(arg).notify =
                    (GtkDestroyNotify)PyGtk_DestroyNotify;
                break;
            case GTK_TYPE_CALLBACK:
                type_check(PyCallable_Check(item))
                Py_INCREF(item);
                GTK_VALUE_CALLBACK(arg).marshal =
                    (GtkCallbackMarshal)PyGtk_CallbackMarshal;
                GTK_VALUE_CALLBACK(arg).data = item;
                GTK_VALUE_CALLBACK(arg).notify =
                    (GtkDestroyNotify)PyGtk_DestroyNotify;
                break;
/*            case GTK_TYPE_ARG:
            case GTK_TYPE_POINTER:
*/            case GTK_TYPE_SIGNAL:
                type_check(PyCallable_Check(item))
                Py_INCREF(item);
                GTK_VALUE_SIGNAL(arg).f = NULL; 
                GTK_VALUE_SIGNAL(arg).d = item;
                break;
            case GTK_TYPE_OBJECT:
                type_check(PyGtk_Check(item))
                GTK_VALUE_OBJECT(arg) = PyGtk_Get(item);
                break;
            default:
                type_check(1)
        }

        gtk_object_setv(o, 1, &arg);

    }
    Py_DECREF(keys);
}

static PyObject *gtk__object_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *dict;

    if (!PyArg_ParseTuple(args, "O!O!:gtk_object_set", &PyGtk_Type, &obj,
                  &PyDict_Type, &dict))
        return NULL;
    PyGtk_object_set(PyGtk_Get(obj), dict);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *gtk__object_new(PyObject *self, PyObject *args) {
    char *name;
    int type;
    PyObject *dict;
    GtkObject *obj;

    if (PyArg_ParseTuple(args, "sO!:gtk_object_new", &name, &PyDict_Type,
                  &dict))
        type = gtk_type_from_name(name);
    else {
        PyErr_Clear();
        if (!PyArg_ParseTuple(args, "iO!:gtk_object_new", &type, &PyDict_Type,
                      &dict))
            return NULL;
        name = gtk_type_name(type);
    }
    obj = gtk_object_newv(type, 0, NULL);
    PyGtk_object_set(obj, dict);
    return PyGtk_New(obj);
}

static PyObject *gtk__object_get(PyObject *self, PyObject *args) {
    PyGtk_Object *o;
    char *name;
    GtkArg garg;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "O!s:gtk_object_get", &PyGtk_Type, &o, &name))
        return NULL;
    garg.name = name;
    gtk_object_getv(PyGtk_Get(o), 1, &garg);

    if (garg.type = GTK_TYPE_INVALID) {
        PyErr_SetString(PyExc_AttributeError, "invalid property");
        return NULL;
    }
    switch (GTK_FUNDAMENTAL_TYPE(garg.type)) {
        case GTK_TYPE_INVALID:
            PyErr_SetString(PyExc_AttributeError, "invalid property");
            return NULL;
        case GTK_TYPE_NONE:
            Py_INCREF(Py_None);
            return Py_None;
        case GTK_TYPE_CHAR:
            return PyString_FromStringAndSize(&GTK_VALUE_CHAR(garg), 1);
        case GTK_TYPE_INT:
            return PyInt_FromLong(GTK_VALUE_INT(garg));
	case GTK_TYPE_UINT:
            return PyInt_FromLong(GTK_VALUE_UINT(garg));
        case GTK_TYPE_BOOL:
            return PyInt_FromLong(GTK_VALUE_BOOL(garg));
        case GTK_TYPE_ULONG:
            return PyInt_FromLong(GTK_VALUE_ULONG(garg));
        case GTK_TYPE_FLOAT:
            return PyFloat_FromDouble(GTK_VALUE_FLOAT(garg));
        case GTK_TYPE_DOUBLE:
            return PyFloat_FromDouble(GTK_VALUE_DOUBLE(garg));
        case GTK_TYPE_STRING:
            ret = PyString_FromString(GTK_VALUE_STRING(garg));
            free(GTK_VALUE_STRING(garg));
            return ret;
        case GTK_TYPE_ENUM:
            return PyInt_FromLong(GTK_VALUE_ENUM(garg));
        case GTK_TYPE_FLAGS:
            return PyInt_FromLong(GTK_VALUE_FLAGS(garg));
        case GTK_TYPE_OBJECT:
            return PyGtk_New(GTK_VALUE_OBJECT(garg));
        case GTK_TYPE_FOREIGN:
            Py_INCREF((PyObject *)GTK_VALUE_FOREIGN(garg).data);
            return (PyObject *)GTK_VALUE_FOREIGN(garg).data;
        case GTK_TYPE_CALLBACK:
            Py_INCREF((PyObject *)GTK_VALUE_CALLBACK(garg).data);
            return (PyObject *)GTK_VALUE_CALLBACK(garg).data;
        case GTK_TYPE_SIGNAL:
            if (GTK_VALUE_SIGNAL(garg).f != (GtkFunction)NULL) {
                PyErr_SetString(PyExc_TypeError, "not a python coded signal");
                return NULL;
            }
            Py_INCREF((PyObject *)GTK_VALUE_SIGNAL(garg).d);
            return (PyObject *)GTK_VALUE_SIGNAL(garg).d;
        case GTK_TYPE_ARGS:
            return GtkArg_to_Tuple(GTK_VALUE_ARGS(garg).n_args,
                GTK_VALUE_ARGS(garg).args);
        case GTK_TYPE_BOXED: /* one of the boxed types */
            if (garg.type == GTK_TYPE_ACCELERATOR_TABLE)
                return PyGtkAccelerator_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_STYLE)
                return PyGtkStyle_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_TOOLTIPS)
                return PyGtkTooltips_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_GDK_EVENT)
                return PyGdkEvent_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_GDK_FONT)
                return PyGdkFont_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_GDK_COLOR)
                return PyGdkColor_New(GTK_VALUE_BOXED(garg));
            else {
                PyErr_SetString(PyExc_TypeError, "unknown type");
                return NULL;
            }
        case GTK_TYPE_POINTER:
        case GTK_TYPE_C_CALLBACK:
            PyErr_SetString(PyExc_AttributeError,
                "property type not implemented");
            return NULL;
    }
}
%}

%native(gtk_object_set) PyObject *gtk__object_set(PyObject *self,
                                                  PyObject *args);
%native(gtk_object_new) PyObject *gtk__object_new(PyObject *self,
                                                  PyObject *args);
%native(gtk_object_get) PyObject *gtk__object_get(PyObject *self,
                                                  PyObject *args);







