# typemaps for Gdk types

%typemap(python,ignore) GdkRectangle *out {
        $target = malloc(sizeof(GdkRectangle));
    }

%typemap(python,freearg) GdkRectangle *out {
        free($source);
    }

%typemap(python,argout) GdkRectangle *out {
        $target = Py_BuildValue("(iiii)", $source->x, $source->y,
                   $source->width, $source->height);
    }

%typemap(python,in) GdkRectangle * {
        if (!PyTuple_Check($source)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        $target = malloc(sizeof(GdkRectangle));
        if (!PyArg_ParseTuple($source, "iiii", &($target->x), &($target->x), &($target->width), &($target->height))) {
            free($target);
            return NULL;
        }
    }

%typemap(python,freearg) GdkRectangle * {
        free($source);
    }

%typemap(python,in) GdkFont * {
        if (PyGdkFont_Check($source))
            $target = PyGdkFont_Get($source);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkFont");
            return NULL;
        }
    }
%typemap(python,out) GdkFont * {
        $target = PyGdkFont_New($source);
    }

%typemap(python,in) GdkColor * {
        if (PyGdkColor_Check($source))
            $target = PyGdkColor_Get($source);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
            return NULL;
        }
   }
%typemap(python,out) GdkColor * {
        $target = PyGdkColor_New($source);
   }

%typemap(python,in) GdkEvent * {
        if (PyGdkEvent_Check($source))
            $target = PyGdkEvent_Get($source);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkEvent");
            return NULL;
        }
    }
%typemap(python,out) GdkEvent * {
        $target = PyGdkEvent_New($source);
    }
